export function dirname(path: string): string {
  const normalized = path.replace(/\\/g, '/');
  const idx = normalized.lastIndexOf('/');
  if (idx <= 0) {
    return '.';
  }
  return normalized.slice(0, idx);
}

export function join(...parts: string[]): string {
  return parts
    .filter((part) => part.length > 0)
    .join('/')
    .replace(/\\/g, '/')
    .replace(/\/+/g, '/');
}
