package moe.mycard.tabulator.model.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import moe.mycard.tabulator.model.mapper.LogMapper;
import moe.mycard.tabulator.model.po.LogPO;
import moe.mycard.tabulator.model.service.ILogService;
import moe.mycard.tabulator.tool.UtilTime;
import org.springframework.stereotype.Service;

/**
 * 主表 - 行为日志 服务实现类
 *
 * @author SPiCa
 * @since 2022-03-23
 */
@Service
public class LogServiceImpl extends ServiceImpl<LogMapper, LogPO> implements ILogService {
  @Override
  public void create(Integer userId, String content) {
    LogPO savePO = new LogPO();
    savePO.setLogContent(userId + ". " + content);
    savePO.setTimeCreate(UtilTime.getDateL());
    save(savePO);
  }
}
