package moe.mycard.tabulator.model.dto;

import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
public class ReturnMessage<T> extends BlankReturnMessage {

  private T data;

  public static <vo> ReturnMessage<vo> ok() {
    ReturnMessage<vo> result = new ReturnMessage<>();
    result.setCode(100);
    result.setMessage("操作成功");
    return result;
  }

  public static <vo> ReturnMessage<vo> data(vo data) {
    ReturnMessage<vo> result = new ReturnMessage<>();
    result.setCode(100);
    result.setMessage("操作成功");
    result.setData(data);
    return result;
  }

  public static ReturnMessage<?> error(Integer code, String message) {
    ReturnMessage<?> result = new ReturnMessage<>();
    result.setCode(code);
    result.setMessage(message);
    return result;
  }

  public static ReturnMessage<?> error(String message) {
    ReturnMessage<?> result = new ReturnMessage<>();
    result.setCode(300);
    result.setMessage(message);
    return result;
  }

  public static ReturnMessage<?> error() {
    ReturnMessage<?> result = new ReturnMessage<>();
    result.setCode(300);
    result.setMessage("系统异常");
    return result;
  }
}
