# 萌卡账号对接流程

## API

### 登陆接口

`POST https://sapi.moecube.com:444/accounts/signin`

该接口不应该前端或后端出现，仅供开发时调试使用。

#### 参数

参数使用 json 或 form 均可。

- `account`
- `password`

#### 返回数据

相关数据经过脱敏处理。标为 `_masked` 的字段为原本如此。

```json
{
  "user": {
    "id": 11111,
    "username": "Nanahira",
    "name": "Nanahira",
    "email": "78877@qq.com",
    "password_hash": "_masked",
    "salt": "_masked",
    "active": true,
    "admin": true,
    "avatar": "https://cdn02.moecube.com:444/avatars/6bfb04a0-67e4-11ec-832c-dbe2719d31fa.png",
    "locale": "zh-CN",
    "registration_ip_address": "_masked",
    "ip_address": "_masked",
    "created_at": "2018-01-01T04:03:41.000Z",
    "updated_at": "2021-12-28T13:45:30.732Z"
  },
  "token": "<很长一大串>"
}
```

> = 400 的返回数据为失败，结果为

```json
{
  "message": "Authentication Error"
}
```

### 用户验证

`GET https://sapi.moecube.com:444/accounts/authUser`

前端应该使用该接口验证 token 时效性，而后端也应该使用该接口验证用户 token 是否合法，以及获取相关的用户信息。

#### 参数

使用 Header 为 `Authorization: Bearer <token>`

#### 返回数据

200 以外返回数据为 token 无效，例如

```json
{
  "message": "Authentication Error"
}
```

该 message 应该直接呈现给前端。若为 401 则后端原样返回 401 给前端。前端收到 401 应立即给予用户需要登陆的提示，并跳转到登陆页面。

200 成功返回数据：

```json
{
  "id": 11111,
  "username": "Nanahira",
  "name": "Nanahira",
  "email": "78877@qq.com",
  "password_hash": "_masked",
  "salt": "_masked",
  "active": true,
  "admin": true,
  "avatar": "https://cdn02.moecube.com:444/avatars/6bfb04a0-67e4-11ec-832c-dbe2719d31fa.png",
  "locale": "zh-CN",
  "registration_ip_address": "_masked",
  "ip_address": "_masked",
  "created_at": "2018-01-01T04:03:41.000Z",
  "updated_at": "2021-12-28T13:45:30.732Z"
}
```

## SSO

下列逻辑为萌卡登陆页面的相关逻辑。

### 进入登陆页面

`GET https://accounts.moecube.com/signin?sso=`

#### `sso` 参数构造方式

下列例子为 TypeScript 语法。JavaScript 用户把相关类型删除即可。

```ts
function loginUrl(callbackUrl: string) {
    let params = new URLSearchParams();
    params.set('return_sso_url', callbackUrl);
    const payload = Buffer.from(params.toString()).toString('base64');
    const url = new URL('https://accounts.moecube.com');
    params = url['searchParams'];
    params.set('sso', payload);
    return url.toString();
}
```

### 回调处理

用户完成登陆流程后，会根据给定的回调 URL 进行跳转，并附加 sso 字段。对该 sso 字段进行 base64 解码后，可以得到下面的数据。使用 URLSearchParams 进行解析即可。

```
id=111111&username=Nanahira&name=Nanahira&email=78877%40qq.com&password_hash=_masked&salt=_masked&active=true&admin=true&avatar=https%3A%2F%2Fcdn02.moecube.com%3A444%2Favatars%2F6bfb04a0-67e4-11ec-832c-dbe2719d31fa.png&locale=zh-CN&registration_ip_address=_masked&ip_address=_masked&created_at=2018-01-01T04%3A03%3A41.000Z&updated_at=2021-12-28T13%3A45%3A30.732Z&return_sso_url=https%3A%2F%2Fwww.example.com&external_id=351863&avatar_url=https%3A%2F%2Fcdn02.moecube.com%3A444%2Favatars%2F6bfb04a0-67e4-11ec-832c-dbe2719d31fa.png&avatar_force_update=true&token=my_token
```

解码后为

```
URLSearchParams {
  'id' => '111111',
  'username' => 'Nanahira',
  'name' => 'Nanahira',
  'email' => '78877@qq.com',
  'password_hash' => '_masked',
  'salt' => '_masked',
  'active' => 'true',
  'admin' => 'true',
  'avatar' => 'https://cdn02.moecube.com:444/avatars/6bfb04a0-67e4-11ec-832c-dbe2719d31fa.png',
  'locale' => 'zh-CN',
  'registration_ip_address' => '_masked',
  'ip_address' => '_masked',
  'created_at' => '2018-01-01T04:03:41.000Z',
  'updated_at' => '2021-12-28T13:45:30.732Z',
  'return_sso_url' => 'https://www.example.com',
  'external_id' => '351863',
  'avatar_url' => 'https://cdn02.moecube.com:444/avatars/6bfb04a0-67e4-11ec-832c-dbe2719d31fa.png',
  'avatar_force_update' => 'true',
  'token' => 'my_token' 
}
```

该 token 字段即可用于后续的 API 的 `Authorization: Bearer <token>` 头部。

## 参考项目

https://code.mycard.moe/mycard/mycard-mobile/-/blob/master/src/app/login.service.ts#L13
https://code.mycard.moe/mycard/mycard-mobile/-/blob/master/src/app/auth.guard.ts#L16
