package moe.mycard.tabulator.model.po;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 主表 - 用户表
 * </p>
 *
 * @author SPiCa
 * @since 2022-03-23
 */
@TableName("ta_user")
@ApiModel(value = "User对象", description = "主表 - 用户表")
public class UserPO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("用户 - 主键")
    private Integer userId;

    @ApiModelProperty("用户 - 标识")
    private String userMark;

    @ApiModelProperty("时间 - 创建时间")
    private LocalDateTime timeCreate;

    @ApiModelProperty("时间 - 登录时间")
    private LocalDateTime timeLogin;

    public Integer getUserId() {
        return userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }
    public String getUserMark() {
        return userMark;
    }

    public void setUserMark(String userMark) {
        this.userMark = userMark;
    }
    public LocalDateTime getTimeCreate() {
        return timeCreate;
    }

    public void setTimeCreate(LocalDateTime timeCreate) {
        this.timeCreate = timeCreate;
    }
    public LocalDateTime getTimeLogin() {
        return timeLogin;
    }

    public void setTimeLogin(LocalDateTime timeLogin) {
        this.timeLogin = timeLogin;
    }

    @Override
    public String toString() {
        return "User{" +
            "userId=" + userId +
            ", userMark=" + userMark +
            ", timeCreate=" + timeCreate +
            ", timeLogin=" + timeLogin +
        "}";
    }
}
