package moe.mycard.tabulator.exception;

import lombok.val;
import moe.mycard.tabulator.model.dto.ReturnMessage;

/**
 * 统一异常类
 *
 * @author SPiCa
 */
public class CavException extends RuntimeException {

  private Integer code;

  /**
   * 异常实现
   *
   * @param message 异常信息
   */
  private CavException(String message) {
    super(message);
  }

  /**
   * 抛出异常接口 统一头部输出信息 headerMessage
   *
   * @param message 异常信息
   * @return FileException 异常对象
   */
  public static CavException cast(String message) {
    return new CavException(message);
  }

  /**
   * 抛出异常接口 统一头部输出信息 headerMessage
   *
   * @param message 异常信息
   * @return FileException 异常对象
   */
  public static CavException cast(Integer code, String message) {
    val error = new CavException(message);
    error.code = code;
    return error;
  }

  /**
   * 直接返回result内容
   *
   * @return 异常信息
   */
  public ReturnMessage<?> result() {
    return ReturnMessage.error(code, this.getMessage());
  }
}
