package moe.mycard.tabulator.tool;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

/**
 * 时间工具类
 *
 * @author SPiCa
 */
public class UtilTime {

  /**
   * 获取时间
   *
   * @return Data 类型
   */
  public static Date getDate() {
    return new Date();
  }

  /**
   * 获取时间
   *
   * @return long 时间戳
   */
  public static long getDateLong() {
    return System.currentTimeMillis();
  }

  /**
   * 获取时间
   *
   * @return LocalDateTime 类型
   */
  public static LocalDateTime getDateL() {
    return LocalDateTime.now();
  }

  /**
   * 获取时间字符串
   *
   * @return 年-月-日 时:分:秒
   */
  public static String getDateStr() {
    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(System.currentTimeMillis()));
  }

  /**
   * 获取时间字符串
   *
   * @return 年-月-日 时:分:秒
   */
  public static String getDateStr(Long l) {
    Date date = new Date(l);
    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
  }

  /**
   * 获取时间字符串
   *
   * @return 年-月-日 时:分:秒
   */
  public static String getDateStr(LocalDateTime time) {
    Date date = Date.from(time.atZone(ZoneId.systemDefault()).toInstant());
    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
  }

  /**
   * 获取时间字符串
   *
   * @return 年-月-日
   */
  public static String getDateStrYmd() {
    return new SimpleDateFormat("yyyy-MM-dd").format(new Date(System.currentTimeMillis()));
  }
}
