package moe.mycard.tabulator.model.po;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 主表 - 座位记录表
 * </p>
 *
 * @author SPiCa
 * @since 2022-03-23
 */
@TableName("ta_seat_record")
@ApiModel(value = "SeatRecord对象", description = "主表 - 座位记录表")
public class SeatRecordPO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("座位记录 - 主键id")
    @TableId(value = "record_id", type = IdType.AUTO)
    private Integer recordId;

    @ApiModelProperty("座位记录 - 当前座次")
    private Integer recordSeat;

    @ApiModelProperty("座位记录 - 当前轮次")
    private Integer recordRound;

    @ApiModelProperty("外键 >> 参赛者 - 主键id")
    private Integer contestantsId;

    @ApiModelProperty("外键 >> 对局 - 主键id")
    private Integer matchId;

    @ApiModelProperty("时间 - 创建时间")
    private LocalDateTime timeCreate;

    @ApiModelProperty("时间 - 修改时间")
    private LocalDateTime timeUpdate;

    @ApiModelProperty("是否有效 ")
    private Boolean isValid;

    @ApiModelProperty("备注")
    private String remark;

    public Integer getRecordId() {
        return recordId;
    }

    public void setRecordId(Integer recordId) {
        this.recordId = recordId;
    }
    public Integer getRecordSeat() {
        return recordSeat;
    }

    public void setRecordSeat(Integer recordSeat) {
        this.recordSeat = recordSeat;
    }
    public Integer getRecordRound() {
        return recordRound;
    }

    public void setRecordRound(Integer recordRound) {
        this.recordRound = recordRound;
    }
    public Integer getContestantsId() {
        return contestantsId;
    }

    public void setContestantsId(Integer contestantsId) {
        this.contestantsId = contestantsId;
    }
    public Integer getMatchId() {
        return matchId;
    }

    public void setMatchId(Integer matchId) {
        this.matchId = matchId;
    }
    public LocalDateTime getTimeCreate() {
        return timeCreate;
    }

    public void setTimeCreate(LocalDateTime timeCreate) {
        this.timeCreate = timeCreate;
    }
    public LocalDateTime getTimeUpdate() {
        return timeUpdate;
    }

    public void setTimeUpdate(LocalDateTime timeUpdate) {
        this.timeUpdate = timeUpdate;
    }
    public Boolean getIsValid() {
        return isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public String toString() {
        return "SeatRecord{" +
            "recordId=" + recordId +
            ", recordSeat=" + recordSeat +
            ", recordRound=" + recordRound +
            ", contestantsId=" + contestantsId +
            ", matchId=" + matchId +
            ", timeCreate=" + timeCreate +
            ", timeUpdate=" + timeUpdate +
            ", isValid=" + isValid +
            ", remark=" + remark +
        "}";
    }
}
