package moe.mycard.tabulator.model.po;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 主表 - 参赛者
 *
 * @author SPiCa
 * @since 2022-03-23
 */
@Data
@TableName("ta_participant")
@ApiModel(value = "Participant对象", description = "主表 - 参赛者")
public class ParticipantPO implements Serializable {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty("参赛者 - 主键")
  @TableId(value = "participant_id", type = IdType.AUTO)
  private Integer participantId;

  @ApiModelProperty("参赛者 - 参赛昵称")
  private String participantName;

  @ApiModelProperty("参赛者 - 参赛QQ")
  private String participantQQ;

  @ApiModelProperty("参赛者 - 参赛卡组")
  private String participantDeck;

  @ApiModelProperty("外键 >> 比赛 - 主键id")
  private Integer tournamentId;

  @ApiModelProperty("时间 - 创建时间")
  private LocalDateTime timeCreate;

  @ApiModelProperty("是否有效 1是 0否")
  private Boolean isValid;
}
