package moe.mycard.tabulator.model.po;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 主表 - 行为日志
 *
 * @author SPiCa
 * @since 2022-03-23
 */
@TableName("ta_log")
@ApiModel(value = "Log对象", description = "主表 - 行为日志")
public class LogPO implements Serializable {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty("日志 - 主键")
  @TableId(value = "log_id", type = IdType.AUTO)
  private Integer logId;

  @ApiModelProperty("日志 - 内容")
  private String logContent;

  @ApiModelProperty("时间 - 创建时间")
  private LocalDateTime timeCreate;

  public Integer getLogId() {
    return logId;
  }

  public void setLogId(Integer logId) {
    this.logId = logId;
  }

  public String getLogContent() {
    return logContent;
  }

  public void setLogContent(String logContent) {
    this.logContent = logContent;
  }

  public LocalDateTime getTimeCreate() {
    return timeCreate;
  }

  public void setTimeCreate(LocalDateTime timeCreate) {
    this.timeCreate = timeCreate;
  }

  @Override
  public String toString() {
    return "Log{"
        + "logId="
        + logId
        + ", logContent="
        + logContent
        + ", timeCreate="
        + timeCreate
        + "}";
  }
}
