package moe.mycard.tabulator.model.po;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 核心 - 配置表
 * </p>
 *
 * @author SPiCa
 * @since 2022-03-23
 */
@TableName("core_config")
@ApiModel(value = "Config对象", description = "核心 - 配置表")
public class ConfigPO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("核心配置 - 主键id")
    @TableId(value = "core_id", type = IdType.AUTO)
    private Integer coreId;

    @ApiModelProperty("核心配置 - key")
    private String coreKey;

    @ApiModelProperty("核心配置 - value")
    private String coreValue;

    @ApiModelProperty("核心配置 - 备注")
    private String coreRemark;

    @ApiModelProperty("时间 - 创建时间")
    private LocalDateTime timeCreate;

    @ApiModelProperty("时间 - 修改时间")
    private LocalDateTime timeUpdate;

    @ApiModelProperty("是否删除")
    private Boolean isDel;

    public Integer getCoreId() {
        return coreId;
    }

    public void setCoreId(Integer coreId) {
        this.coreId = coreId;
    }
    public String getCoreKey() {
        return coreKey;
    }

    public void setCoreKey(String coreKey) {
        this.coreKey = coreKey;
    }
    public String getCoreValue() {
        return coreValue;
    }

    public void setCoreValue(String coreValue) {
        this.coreValue = coreValue;
    }
    public String getCoreRemark() {
        return coreRemark;
    }

    public void setCoreRemark(String coreRemark) {
        this.coreRemark = coreRemark;
    }
    public LocalDateTime getTimeCreate() {
        return timeCreate;
    }

    public void setTimeCreate(LocalDateTime timeCreate) {
        this.timeCreate = timeCreate;
    }
    public LocalDateTime getTimeUpdate() {
        return timeUpdate;
    }

    public void setTimeUpdate(LocalDateTime timeUpdate) {
        this.timeUpdate = timeUpdate;
    }
    public Boolean getIsDel() {
        return isDel;
    }

    public void setIsDel(Boolean isDel) {
        this.isDel = isDel;
    }

    @Override
    public String toString() {
        return "Config{" +
            "coreId=" + coreId +
            ", coreKey=" + coreKey +
            ", coreValue=" + coreValue +
            ", coreRemark=" + coreRemark +
            ", timeCreate=" + timeCreate +
            ", timeUpdate=" + timeUpdate +
            ", isDel=" + isDel +
        "}";
    }
}
