package moe.mycard.tabulator.common;

import moe.mycard.tabulator.exception.CavException;
import moe.mycard.tabulator.model.epi.MyCardEPI;
import moe.mycard.tabulator.model.epi.ResponseEPI;
import moe.mycard.tabulator.redis.Auth_RedisKey;
import moe.mycard.tabulator.tool.UtilEPI;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@Component
public class LoginInterceptor implements HandlerInterceptor {

  public boolean isAuth = true;

  @Resource private RedisTemplate<String, Long> redisTemplate;

  /**
   * 这个方法是在访问接口之前执行的，我们只需要在这里写验证登陆状态的业务逻辑，就可以在用户调用指定接口之前验证登陆状态了
   *
   * @param request current HTTP request
   * @param response current HTTP response
   * @param handler chosen handler to execute, for type and/or instance evaluation
   */
  public boolean preHandle(
      @NotNull HttpServletRequest request,
      @NotNull HttpServletResponse response,
      @NotNull Object handler) {
    if (isAuth) {
      String token = request.getHeader("Authorization");
      if (token == null) {
        throw CavException.cast(301, "无权访问");
      } else {
        authCheck(token);
      }
    }
    return true;
  }

  private void authCheck(String token) {
    String _key = Auth_RedisKey.group;
    Long cacheUserId = redisTemplate.opsForValue().get(token);
    if (cacheUserId == null) {
      // ===== 是否在c萌服务器存在 =====
      Request request =
          new Request.Builder()
              .url("https://sapi.moecube.com:444/accounts/authUser")
              .method("GET", null)
              .addHeader("Authorization", token)
              .build();
      try (Response response = new OkHttpClient().newBuilder().build().newCall(request).execute()) {
        ResponseEPI<MyCardEPI> epi = UtilEPI.getMyCard(response);
        if (epi.getCode() != 200) {
          throw CavException.cast(301, "无权访问" + epi.getData().getMessage());
        } else {
          redisTemplate
              .opsForValue()
              .set(_key + token, epi.getData().encryptionId(), 1, TimeUnit.HOURS);
        }
      } catch (IOException e) {
        throw CavException.cast(301, "无权访问,系统IO异常");
      } catch (NullPointerException e) {
        throw CavException.cast(301, "无权访问,请求失败");
      }
      // ===== 是否在c萌服务器存在 =====
    } else {
      redisTemplate.opsForValue().set(_key + token, cacheUserId, 1, TimeUnit.HOURS);
    }
  }

}
