import { Controller } from '@nestjs/common';
import { TournamentService } from './tournament.service';
import { RestfulFactory } from 'nicot';
import { Tournament } from './entities/Tournament.entity';
import { MycardUser, PutMycardUser } from 'nestjs-mycard';
import { ApiHeader, ApiTags } from '@nestjs/swagger';

const factory = new RestfulFactory(Tournament);
class FindTournamentDto extends factory.findAllDto {}
class UpdateTournamentDto extends factory.updateDto {}

@ApiTags('tournament')
@Controller('tournament')
@ApiHeader({ name: 'Authorization', required: false, description: 'MC Token' })
export class TournamentController {
  constructor(private readonly tournamentService: TournamentService) {}

  @factory.create()
  async create(
    @factory.createParam() tournament: Tournament,
    @PutMycardUser() user: MycardUser,
  ) {
    return this.tournamentService.createTournament(tournament, user);
  }

  @factory.findOne()
  async findOne(
    @factory.idParam() id: number,
    @PutMycardUser(false) user: MycardUser,
  ) {
    return this.tournamentService.getTournament(id, user);
  }

  @factory.findAll()
  async findAll(
    @factory.findAllParam() dto: FindTournamentDto,
    @PutMycardUser(false) user: MycardUser,
  ) {
    return this.tournamentService.getTournaments(dto, user);
  }

  @factory.update()
  async update(
    @factory.idParam() id: number,
    @factory.updateParam() dto: UpdateTournamentDto,
    @PutMycardUser() user: MycardUser,
  ) {
    return this.tournamentService.updateTournament(id, dto, user);
  }

  @factory.delete()
  async delete(
    @factory.idParam() id: number,
    @PutMycardUser() user: MycardUser,
  ) {
    return this.tournamentService.deleteTournament(id, user);
  }
}
