import { Module } from '@nestjs/common';
import { ParticipantService } from './participant.service';
import { ParticipantController } from './participant.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Participant } from './entities/participant.entity';
import { TournamentModule } from '../tournament/tournament.module';

@Module({
  controllers: [ParticipantController],
  providers: [ParticipantService],
  imports: [TypeOrmModule.forFeature([Participant]), TournamentModule],
})
export class ParticipantModule {}
