import { Entity, ManyToOne, SelectQueryBuilder } from 'typeorm';
import { NamedBase } from '../../utility/NamedBase.entity';
import {
  applyQueryProperty,
  BoolColumn,
  NotChangeable,
  NotColumn,
} from 'nicot';
import { TournamentIdColumn } from '../../utility/decorators/tournament-id-column';
import {
  Tournament,
  TournamentVisibility,
} from '../../tournament/entities/Tournament.entity';
import { MycardUser } from 'nestjs-mycard';

@Entity()
export class Participant extends NamedBase {
  @BoolColumn({ default: false, description: '是否已经退赛' })
  quit: boolean;

  @NotChangeable()
  @TournamentIdColumn(true)
  tournamentId: number;

  @NotColumn()
  @ManyToOne(() => Tournament, (tournament) => tournament.participants)
  tournament: Tournament;

  checkPermission(user: MycardUser) {
    return this.tournament?.checkPermission(user);
  }

  applyQuery(qb: SelectQueryBuilder<Participant>, entityName: string) {
    super.applyQuery(qb, entityName);
    applyQueryProperty(this, qb, entityName, 'quit', 'tournamentId');
  }
}
