import yaml from 'yaml';
import * as fs from 'fs';

const defaultConfig = {
  host: '::',
  port: 3000,
  DB_HOST: 'localhost',
  DB_PORT: 5432,
  DB_USER: 'mycard',
  DB_PASS: 'mycard',
  DB_NAME: 'mycard',
};

export type Config = typeof defaultConfig;

export async function loadConfig(): Promise<Config> {
  let readConfig: Partial<Config> = {};
  try {
    const configText = await fs.promises.readFile('./config.yaml', 'utf-8');
    readConfig = yaml.parse(configText);
  } catch (e) {
    console.error(`Failed to read config: ${e.toString()}`);
  }
  return {
    ...defaultConfig,
    ...readConfig,
    ...process.env,
  };
}
