import {
  applyQueryPropertyLike,
  applyQueryPropertySearch,
  IdBase,
  StringColumn,
} from 'nicot';
import { Index, SelectQueryBuilder } from 'typeorm';

export class NamedBase extends IdBase() {
  @Index()
  @StringColumn(128, { required: true, description: '名称' })
  name: string;

  applyQuery(qb: SelectQueryBuilder<NamedBase>, entityName: string) {
    super.applyQuery(qb, entityName);
    applyQueryPropertyLike(this, qb, entityName, 'name');
  }
}

export class DescBase extends NamedBase {
  @StringColumn(10000, { default: '暂无介绍。', description: '描述' })
  description: string;

  applyQuery(qb: SelectQueryBuilder<DescBase>, entityName: string) {
    super.applyQuery(qb, entityName);
    applyQueryPropertySearch(this, qb, entityName, 'description');
  }
}
