import { Module } from '@nestjs/common';
import { TournamentService } from './tournament.service';
import { TournamentController } from './tournament.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Tournament } from './entities/Tournament.entity';
import { Match } from '../match/entities/match.entity';

@Module({
  controllers: [TournamentController],
  providers: [TournamentService],
  imports: [TypeOrmModule.forFeature([Tournament, Match])],
  exports: [TournamentService],
})
export class TournamentModule {}
