import { Injectable } from '@nestjs/common';
import { CrudService, Inner } from 'nicot';
import { Match } from './entities/match.entity';
import { InjectRepository } from '@nestjs/typeorm';
import { MycardUser } from 'nestjs-mycard';
import { Tournament } from '../tournament/entities/Tournament.entity';
import { Participant } from '../participant/entities/participant.entity';

@Injectable()
export class MatchService extends CrudService(Match, {
  relations: [Inner('tournament'), 'player1', 'player2', 'winner'],
}) {
  constructor(@InjectRepository(Match) repo) {
    super(repo);
  }

  getMatch(id: number, user: MycardUser) {
    return this.findOne(id, (qb) =>
      Tournament.extraQueryForUser(user, qb, 'tournament'),
    );
  }

  getMatches(dto: Partial<Participant>, user: MycardUser) {
    return this.findAll(dto, (qb) =>
      Tournament.extraQueryForUser(user, qb, 'tournament'),
    );
  }
}
