import { Controller } from '@nestjs/common';
import { MatchService } from './match.service';
import { RestfulFactory } from 'nicot';
import { Match } from './entities/match.entity';
import { ApiHeader, ApiTags } from '@nestjs/swagger';
import { MycardUser, PutMycardUser } from 'nestjs-mycard';

const factory = new RestfulFactory(Match);
class FindMatchDto extends factory.findAllDto {}
class UpdateMatchDto extends factory.updateDto {}

@Controller('match')
@ApiHeader({ name: 'Authorization', required: false, description: 'MC Token' })
@ApiTags('match')
export class MatchController {
  constructor(private readonly matchService: MatchService) {}

  @factory.findOne()
  findOne(@factory.idParam() id: number, @PutMycardUser() user: MycardUser) {
    return this.matchService.getMatch(id, user);
  }

  @factory.findAll()
  findAll(
    @factory.findAllParam() dto: FindMatchDto,
    @PutMycardUser() user: MycardUser,
  ) {
    return this.matchService.getMatches(dto, user);
  }
}
