import { QueryCondition } from 'nicot';
import moment from 'moment';

export const QuerySinceDaysAgo = (dateField: string) =>
  QueryCondition((obj, qb, entityName, key) => {
    if (!obj[key]) return;
    const since = moment().subtract(obj[key], 'days').toDate();
    const typeormKey = `since_${entityName}_${dateField}_${key}`;
    qb.andWhere(`${entityName}.${dateField} > :${typeormKey}`, {
      [typeormKey]: since,
    });
  });
