import { IdBase, NotQueryable, QueryLike, StringColumn } from 'nicot';
import { Index } from 'typeorm';

export class NamedBase extends IdBase() {
  @Index()
  @QueryLike()
  @StringColumn(128, { required: true, description: '名称' })
  name: string;
}

export class DescBase extends NamedBase {
  @NotQueryable()
  @StringColumn(10000, { default: '暂无介绍。', description: '描述' })
  description: string;
}
