import { Tournament } from '../tournament/entities/Tournament.entity';
import { Match, MatchStatus } from '../match/entities/match.entity';
import { Repository } from 'typeorm';
import {
  Participant,
  ParticipantScore,
} from '../participant/entities/participant.entity';

export class TournamentRuleBase {
  protected participantMap = new Map<number, Participant>();

  constructor(
    protected tournament: Tournament,
    protected repo?: Repository<Match>,
  ) {
    this.tournament.participants?.forEach((p) =>
      this.participantMap.set(p.id, p),
    );
  }

  async saveMatch(matches: Match[]) {
    matches.forEach((m) => (m.tournamentId = this.tournament.id));
    return this.repo.save(matches);
  }

  currentRoundCount() {
    return Math.max(
      ...this.tournament.matches
        .filter(
          (m) =>
            m.status === MatchStatus.Finished ||
            m.status === MatchStatus.Running,
        )
        .map((m) => m.round),
    );
  }

  nextRoundCount() {
    return this.currentRoundCount() + 1;
  }

  async initialize() {}
  nextRound(): Partial<Match[]> {
    return [];
  }

  specificMatches(status: MatchStatus) {
    return this.tournament.matches.filter((m) => m.status === status);
  }

  participantScore(participant: Participant): Partial<ParticipantScore> {
    const finishedMatches = this.specificMatches(MatchStatus.Finished);
    return {
      win: finishedMatches.filter((m) => m.winnerId === participant.id).length,
      lose: finishedMatches.filter(
        (m) =>
          m.winnerId &&
          m.winnerId !== participant.id &&
          m.participated(participant.id),
      ).length,
      draw: finishedMatches.filter(
        (m) => !m.winnerId && m.participated(participant.id),
      ).length,
    };
  }

  participantScoreAfter(participant: Participant): Partial<ParticipantScore> {
    return {};
  }
}
