import { Injectable } from '@nestjs/common';
import { TournamentService } from '../tournament/tournament.service';
import { ParticipantService } from '../participant/participant.service';
import { MatchService } from '../match/match.service';
import {
  SRVProTournamentDto,
  SRVProUploadMatchDto,
  srvproUploadMatchToUpdateMatch,
  SRVProUploadParticipantDto,
} from './srvpro.dto';
import { Participant } from '../participant/entities/participant.entity';

@Injectable()
export class SrvproService {
  constructor(
    private tournamentService: TournamentService,
    private participantService: ParticipantService,
    private matchService: MatchService,
  ) {}

  async getTournament(tournamentId: number, userId: number) {
    const res = await this.tournamentService.getTournament(
      tournamentId,
      userId,
    );
    return new SRVProTournamentDto(res.data);
  }

  async putScore(
    tournamentId: number,
    matchId: number,
    body: SRVProUploadMatchDto,
    userId: number,
  ) {
    return this.matchService.updateMatch(
      matchId,
      srvproUploadMatchToUpdateMatch(body.match),
      userId,
    );
  }

  async clearParticipants(tournamentId: number, userId: number) {
    return this.tournamentService.clearTournamentParticipants(
      tournamentId,
      userId,
    );
  }

  async uploadParticipants(
    tournamentId: number,
    body: SRVProUploadParticipantDto,
    userId: number,
  ) {
    return this.participantService.importParticipants(
      body.participants.map(
        (p) =>
          ({
            ...p,
            tournamentId,
          }) as Participant,
      ),
      userId,
    );
  }
}
