import { Controller } from '@nestjs/common';
import { ParticipantService } from './participant.service';
import { Participant } from './entities/participant.entity';
import { ApiError, Inner, RestfulFactory } from 'nicot';
import { ApiMycardUser, MycardUser, PutMycardUser } from 'nestjs-mycard';
import { ApiTags } from '@nestjs/swagger';

const factory = new RestfulFactory(Participant, {
  relations: [Inner('tournament')],
});
class CreateParticipantDto extends factory.createDto {}
class FindParticipantDto extends factory.findAllDto {}
class UpdateParticipantDto extends factory.updateDto {}
class ImportParticipantDto extends factory.importDto {}

@ApiTags('participant')
@Controller('participant')
@ApiMycardUser({ optional: true })
@ApiError(404, '相关资源未找到')
@ApiError(403, '无法操作，弹 Toast 即可')
export class ParticipantController {
  constructor(private readonly participantService: ParticipantService) {}

  @factory.create()
  async create(
    @factory.createParam() participant: CreateParticipantDto,
    @PutMycardUser() user: MycardUser,
  ) {
    return this.participantService.createParticipant(participant, user);
  }

  @factory.findOne()
  async findOne(
    @factory.idParam() id: number,
    @PutMycardUser(false) user: MycardUser,
  ) {
    return this.participantService.getParticipant(id, user);
  }

  @factory.findAll()
  async findAll(
    @factory.findAllParam() dto: FindParticipantDto,
    @PutMycardUser(false) user: MycardUser,
  ) {
    return this.participantService.getParticipants(dto, user);
  }

  @factory.update()
  async update(
    @factory.idParam() id: number,
    @factory.updateParam() dto: UpdateParticipantDto,
    @PutMycardUser() user: MycardUser,
  ) {
    return this.participantService.updateParticipant(id, dto, user);
  }

  @factory.delete()
  async delete(
    @factory.idParam() id: number,
    @PutMycardUser() user: MycardUser,
  ) {
    return this.participantService.deleteParticipant(id, user);
  }

  @factory.import()
  async import(
    @PutMycardUser() user: MycardUser,
    @factory.createParam() data: ImportParticipantDto,
  ) {
    return this.participantService.importParticipants(data.data, user);
  }
}
