import { Controller } from '@nestjs/common';
import { MatchService } from './match.service';
import { ApiError, Inner, RestfulFactory } from 'nicot';
import { Match } from './entities/match.entity';
import { ApiTags } from '@nestjs/swagger';
import { ApiMycardUser, MycardUser, PutMycardUser } from 'nestjs-mycard';

const factory = new RestfulFactory(Match, {
  relations: [Inner('tournament'), 'player1', 'player2', 'winner'],
});
class FindMatchDto extends factory.findAllDto {}
class UpdateMatchDto extends factory.updateDto {}

@Controller('match')
@ApiMycardUser({ optional: true })
@ApiTags('match')
@ApiError(404, '相关资源未找到')
@ApiError(403, '无法操作，弹 Toast 即可')
export class MatchController {
  constructor(private readonly matchService: MatchService) {}

  @factory.findOne()
  findOne(@factory.idParam() id: number, @PutMycardUser() user: MycardUser) {
    return this.matchService.getMatch(id, user);
  }

  @factory.findAll()
  findAll(
    @factory.findAllParam() dto: FindMatchDto,
    @PutMycardUser() user: MycardUser,
  ) {
    return this.matchService.getMatches(dto, user);
  }

  @factory.update()
  update(
    @factory.idParam() id: number,
    @factory.updateParam() dto: UpdateMatchDto,
    @PutMycardUser() user: MycardUser,
  ) {
    return this.matchService.updateMatch(id, dto, user);
  }
}
