import { Module } from '@nestjs/common';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { loadConfig } from './utility/config';
import { TypeOrmModule } from '@nestjs/typeorm';
import { MycardAuthModule } from 'nestjs-mycard';
import { Tournament } from './tournament/entities/Tournament.entity';
import { Match } from './match/entities/match.entity';
import { Participant } from './participant/entities/participant.entity';
import { TournamentService } from './tournament/tournament.service';
import { MatchService } from './match/match.service';
import { ParticipantService } from './participant/participant.service';
import { TournamentController } from './tournament/tournament.controller';
import { MatchController } from './match/match.controller';
import { ParticipantController } from './participant/participant.controller';
import { ApiKeyService } from './api-key/api-key.service';
import { ApiKey } from './api-key/entities/api-key.entity';
import { ApiKeyController } from './api-key/api-key.controller';
import { SrvproService } from './srvpro/srvpro.service';
import { SrvproController } from './srvpro/srvpro.controller';

@Module({
  imports: [
    {
      ...MycardAuthModule.register(),
      global: true,
    },
    ConfigModule.forRoot({
      load: [loadConfig],
      isGlobal: true,
      ignoreEnvVars: true,
      ignoreEnvFile: true,
    }),
    TypeOrmModule.forRootAsync({
      inject: [ConfigService],
      useFactory: async (config: ConfigService) => ({
        type: 'postgres',
        entities: [],
        autoLoadEntities: true,
        synchronize: !config.get('DB_NO_INIT'),
        host: config.get('DB_HOST'),
        port: parseInt(config.get('DB_PORT')) || 5432,
        username: config.get('DB_USER'),
        password: config.get('DB_PASS'),
        database: config.get('DB_NAME'),
        supportBigNumbers: true,
        bigNumberStrings: false,
        //  logging: true,
      }),
    }),
    TypeOrmModule.forFeature([Tournament, Match, Participant, ApiKey]),
  ],
  providers: [
    TournamentService,
    MatchService,
    ParticipantService,
    ApiKeyService,
    SrvproService,
  ],
  controllers: [
    TournamentController,
    MatchController,
    ParticipantController,
    ApiKeyController,
    SrvproController,
  ],
})
export class AppModule {}
