import { DescBase } from '../../utility/NamedBase.entity';
import {
  DateColumn,
  IntColumn,
  NotQueryable,
  NotWritable,
  StringColumn,
} from 'nicot';
import { Entity, Index } from 'typeorm';
import cryptoRandomString from 'crypto-random-string';

@Entity()
export class ApiKey extends DescBase {
  @NotWritable()
  @Index()
  @IntColumn('int', {
    description: '创建者 MC ID',
    unsigned: true,
    columnExtras: { nullable: false },
  })
  userId: number;

  @Index({ unique: true })
  @NotQueryable()
  @NotWritable()
  @StringColumn(64, {
    description: 'API Key 本体',
    columnExtras: { nullable: false },
  })
  key: string;

  @Index()
  @DateColumn({
    description: 'API Key 过期时间',
  })
  @NotQueryable()
  expireAt: Date;

  async beforeCreate() {
    this.key = cryptoRandomString({ length: 64, type: 'alphanumeric' });
  }
}
