import { Injectable } from '@nestjs/common';
import { BlankReturnMessageDto, CrudService } from 'nicot';
import { ApiKey } from './entities/api-key.entity';
import { InjectRepository } from '@nestjs/typeorm';

class _base extends CrudService(ApiKey) {}

@Injectable()
export class ApiKeyService extends _base {
  constructor(@InjectRepository(ApiKey) repo) {
    super(repo);
  }

  async findUserIdWithApiKey(value: string) {
    const apiKey = await this.repo.findOne({
      where: { key: value },
      select: ['id', 'userId', 'expireAt'],
    });
    if (!apiKey) {
      throw new BlankReturnMessageDto(401, 'Invalid API Key.').toException();
    }
    if (apiKey.expireAt && apiKey.expireAt < new Date()) {
      throw new BlankReturnMessageDto(401, 'API Key expired.').toException();
    }
    return apiKey.userId;
  }
}
