import {
  ArgumentMetadata,
  createParamDecorator,
  ExecutionContext,
  Injectable,
  PipeTransform,
} from '@nestjs/common';
import { ApiKeyService } from './api-key.service';
import { Request } from 'express';

@Injectable()
export class ApiKeyPipe implements PipeTransform {
  constructor(private apiKeyService: ApiKeyService) {}

  transform(value: string, metadata: ArgumentMetadata) {
    return this.apiKeyService.findUserIdWithApiKey(value);
  }
}

const __possibleKeys = createParamDecorator((_, ctx: ExecutionContext) => {
  const req = ctx.switchToHttp().getRequest<Request>();
  const fields = ['query', 'body'] as const;
  for (const field of fields) {
    const res = req?.[field]?.['api_key'];
    if (res) {
      return res as string;
    }
  }
  return '';
});

export const PutApiKeyUserId = () => __possibleKeys(ApiKeyPipe);
