import { Controller } from '@nestjs/common';
import { ApiTags } from '@nestjs/swagger';
import { ApiMycardUser, MycardUser, PutMycardUser } from 'nestjs-mycard';
import { ApiKeyService } from './api-key.service';
import { RestfulFactory } from 'nicot';
import { ApiKey } from './entities/api-key.entity';

const factory = new RestfulFactory(ApiKey);

class CreateApiKeyDto extends factory.createDto {}
class FindApiKeyDto extends factory.findAllDto {}
class UpdateApiKeyDto extends factory.updateDto {}

@ApiTags('api-key')
@Controller('api-key')
@ApiMycardUser()
export class ApiKeyController {
  constructor(private service: ApiKeyService) {}

  @factory.create()
  async create(
    @factory.createParam() dto: CreateApiKeyDto,
    @PutMycardUser() user: MycardUser,
  ) {
    dto.userId = user.id;
    return this.service.create(dto);
  }

  @factory.findOne()
  async findOne(
    @factory.idParam() id: number,
    @PutMycardUser() user: MycardUser,
  ) {
    return this.service.findOne(id, (qb) =>
      qb.andWhere(`${this.service.entityAliasName}.userId = :currentUserId`, {
        currentUserId: user.id,
      }),
    );
  }

  @factory.findAll()
  async findAll(
    @factory.findAllParam() dto: FindApiKeyDto,
    @PutMycardUser() user: MycardUser,
  ) {
    return this.service.findAll(dto, (qb) =>
      qb.andWhere(`${this.service.entityAliasName}.userId = :currentUserId`, {
        currentUserId: user.id,
      }),
    );
  }

  @factory.update()
  async update(
    @factory.idParam() id: number,
    @factory.updateParam() dto: UpdateApiKeyDto,
    @PutMycardUser() user: MycardUser,
  ) {
    return this.service.update(id, dto, { userId: user.id });
  }

  @factory.delete()
  async delete(
    @factory.idParam() id: number,
    @PutMycardUser() user: MycardUser,
  ) {
    return this.service.delete(id, { userId: user.id });
  }
}
