import {
  ConsoleLogger,
  Injectable,
  OnModuleDestroy,
  OnModuleInit,
} from '@nestjs/common';
import find from 'puppeteer-finder';
import puppeteer, { Browser, Page } from 'puppeteer-core';
@Injectable()
export class PuppeteerService
  extends ConsoleLogger
  implements OnModuleInit, OnModuleDestroy
{
  private browser: Browser;
  constructor() {
    super('PuppeteerService');
  }
  async onModuleInit() {
    const executablePath = find() as string;
    this.log(`Found puppeteer executable at ${executablePath}`);
    this.browser = await puppeteer.launch({
      executablePath,
      headless: true,
      args: process.getuid?.() === 0 ? ['--no-sandbox'] : [],
    });
    this.log('Puppeteer launched');
  }

  async onModuleDestroy() {
    await this.browser.close();
  }

  private async doPageAction<T>(
    url: string,
    action: (page: Page) => Promise<T>,
  ) {
    const page = await this.browser.newPage();
    try {
      await page.goto(url, { waitUntil: 'networkidle0', timeout: 300000 });
      return await action(page);
    } finally {
      await page.close();
    }
  }

  render(url: string) {
    return this.doPageAction(url, (p) => p.content());
  }
}
