import { Controller, Get, Req, Res } from '@nestjs/common';
import { AppService } from './app.service';
import { Request, Response } from 'express';

@Controller()
export class AppController {
  constructor(private readonly appService: AppService) {}

  @Get('*')
  async render(@Req() req: Request, @Res({ passthrough: true }) res: Response) {
    const result = await this.appService.render(req, res);
    res.header('Cache-Control', 'public, max-age=3600, immutable');
    return result;
  }
}
