// Generated by CoffeeScript 2.7.0
(function() {
  var YGOProMessagesHelper, _, loadJSON, translateHandler;

  _ = require('underscore');

  _.str = require('underscore.string');

  _.mixin(_.str.exports());

  loadJSON = require('load-json-file').sync;

  this.i18ns = loadJSON('./data/i18n.json');

  this.i18nR = {};

  this.reloadI18nR = function() {
    var data, key, lang, ref, results, text;
    ref = this.i18ns;
    results = [];
    for (lang in ref) {
      data = ref[lang];
      this.i18nR[lang] = {};
      results.push((function() {
        var results1;
        results1 = [];
        for (key in data) {
          text = data[key];
          results1.push(this.i18nR[lang][key] = {
            regex: new RegExp("\\$\\{" + key + "\\}", 'g'),
            text: text
          });
        }
        return results1;
      }).call(this));
    }
    return results;
  };

  this.reloadI18nR();

  YGOProMessagesHelper = require("./YGOProMessages.js").YGOProMessagesHelper; // 为 SRVPro2 准备的库，这里拿这个库只用来测试，SRVPro1 对异步支持不是特别完善，因此不会有很多异步优化

  this.helper = new YGOProMessagesHelper(9000);

  this.structs = this.helper.structs;

  this.constants = this.helper.constants;

  translateHandler = function(handler) {
    return async function(buffer, info, datas, params) {
      return (await handler(buffer, info, params.client, params.server, datas));
    };
  };

  this.stoc_follow = function(proto, synchronous, callback) {
    this.helper.addHandler(`STOC_${proto}`, translateHandler(callback), synchronous, 1);
  };

  this.stoc_follow_before = function(proto, synchronous, callback) {
    this.helper.addHandler(`STOC_${proto}`, translateHandler(callback), synchronous, 0);
  };

  this.stoc_follow_after = function(proto, synchronous, callback) {
    this.helper.addHandler(`STOC_${proto}`, translateHandler(callback), synchronous, 2);
  };

  this.ctos_follow = function(proto, synchronous, callback) {
    this.helper.addHandler(`CTOS_${proto}`, translateHandler(callback), synchronous, 1);
  };

  this.ctos_follow_before = function(proto, synchronous, callback) {
    this.helper.addHandler(`CTOS_${proto}`, translateHandler(callback), synchronous, 0);
  };

  this.ctos_follow_after = function(proto, synchronous, callback) {
    this.helper.addHandler(`CTOS_${proto}`, translateHandler(callback), synchronous, 2);
  };

  //消息发送函数,至少要把俩合起来....
  this.stoc_send = function(socket, proto, info) {
    return this.helper.sendMessage(socket, `STOC_${proto}`, info);
  };

  this.ctos_send = function(socket, proto, info) {
    return this.helper.sendMessage(socket, `CTOS_${proto}`, info);
  };

  //util
  this.split_chat_lines = function(msg, player, lang) {
    var i, len, line, lines, o, r, ref, ref1;
    lines = [];
    ref = _.lines(msg);
    for (i = 0, len = ref.length; i < len; i++) {
      line = ref[i];
      if (player >= 10) {
        line = "[Server]: " + line;
      }
      ref1 = this.i18nR[lang];
      for (o in ref1) {
        r = ref1[o];
        line = line.replace(r.regex, r.text);
      }
      lines.push(line);
    }
    return lines;
  };

  this.stoc_send_chat = async function(client, msg, player = 8) {
    var i, len, line, ref;
    if (!client) {
      console.log("err stoc_send_chat");
      return;
    }
    ref = this.split_chat_lines(msg, player, client.lang);
    for (i = 0, len = ref.length; i < len; i++) {
      line = ref[i];
      await this.stoc_send(client, 'CHAT', {
        player: player,
        msg: line
      });
    }
  };

  this.stoc_send_chat_to_room = function(room, msg, player = 8) {
    var client, i, j, len, len1, ref, ref1;
    if (!room) {
      console.log("err stoc_send_chat_to_room");
      return;
    }
    ref = room.players;
    for (i = 0, len = ref.length; i < len; i++) {
      client = ref[i];
      if (client) {
        this.stoc_send_chat(client, msg, player);
      }
    }
    ref1 = room.watchers;
    for (j = 0, len1 = ref1.length; j < len1; j++) {
      client = ref1[j];
      if (client) {
        this.stoc_send_chat(client, msg, player);
      }
    }
    room.recordChatMessage(msg, player);
  };

  this.stoc_die = async function(client, msg) {
    await this.stoc_send_chat(client, msg, this.constants.COLORS.RED);
    if (client) {
      await this.stoc_send(client, 'ERROR_MSG', {
        msg: 1,
        code: 9
      });
    }
    if (client) {
      client.system_kicked = true;
      client.destroy();
    }
    return '_cancel';
  };

}).call(this);
