// Generated by CoffeeScript 1.10.0
(function() {
  var Cloud_replay_ids, Graveyard, ROOM_all, ROOM_ban_player, ROOM_find_by_name, ROOM_find_by_port, ROOM_find_or_create_by_name, ROOM_find_or_create_random, ROOM_players_banned, ROOM_players_oppentlist, ROOM_validate, Room, _, ban_user, bunyan, crypto, date, defaultconfig, execFile, fs, get_memory_usage, http, http_server, https, https_server, list, load_dialogues, load_tips, log, moment, nconf, net, options, os, path, pg, redis, redisdb, request, requestListener, roomlist, settings, spawn, spawnSync, tribute, url, users_cache, wait_room_start, ygopro, zlib;

  net = require('net');

  http = require('http');

  url = require('url');

  path = require('path');

  fs = require('fs');

  os = require('os');

  crypto = require('crypto');

  execFile = require('child_process').execFile;

  spawn = require('child_process').spawn;

  spawnSync = require('child_process').spawnSync;

  _ = require('underscore');

  _.str = require('underscore.string');

  _.mixin(_.str.exports());

  request = require('request');

  bunyan = require('bunyan');

  log = bunyan.createLogger({
    name: "mycard"
  });

  moment = require('moment');

  moment.locale('zh-cn', {
    relativeTime: {
      future: '%s内',
      past: '%s前',
      s: '%d秒',
      m: '1分钟',
      mm: '%d分钟',
      h: '1小时',
      hh: '%d小时',
      d: '1天',
      dd: '%d天',
      M: '1个月',
      MM: '%d个月',
      y: '1年',
      yy: '%d年'
    }
  });

  nconf = require('nconf');

  nconf.file('./config.user.json');

  defaultconfig = require('./config.json');

  nconf.defaults(defaultconfig);

  settings = global.settings = nconf.get();

  nconf.myset = function(settings, path, val) {
    var key, target;
    nconf.set(path, val);
    nconf.save();
    if (_.isString(val)) {
      log.info("setting changed", path, val);
    }
    path = path.split(':');
    if (path.length === 0) {
      settings[path[0]] = val;
    } else {
      target = settings;
      while (path.length > 1) {
        key = path.shift();
        target = target[key];
      }
      key = path.shift();
      target[key] = val;
    }
  };

  ban_user = function(name) {
    var k, l, len, len1, player, ref, room;
    settings.ban.banned_user.push(name);
    nconf.myset(settings, "ban:banned_user", settings.ban.banned_user);
    for (k = 0, len = ROOM_all.length; k < len; k++) {
      room = ROOM_all[k];
      if (room && room.established) {
        ref = room.players;
        for (l = 0, len1 = ref.length; l < len1; l++) {
          player = ref[l];
          if (player && player.name === name) {
            settings.ban.banned_ip.push(player.remoteAddress);
            ygopro.stoc_send_chat_to_room(room, player.name + " 被系统请出了房间", ygopro.constants.COLORS.RED);
            player.end();
            continue;
          }
        }
      }
    }
  };

  settings.version = parseInt(fs.readFileSync('ygopro/gframe/game.cpp', 'utf8').match(/PRO_VERSION = ([x\dABCDEF]+)/)[1], '16');

  settings.lflist = (function() {
    var k, len, ref, results;
    ref = fs.readFileSync('ygopro/lflist.conf', 'utf8').match(/!.*/g);
    results = [];
    for (k = 0, len = ref.length; k < len; k++) {
      list = ref[k];
      date = list.match(/!([\d\.]+)/);
      if (!date) {
        continue;
      }
      results.push({
        date: moment(list.match(/!([\d\.]+)/)[1], 'YYYY.MM.DD').utcOffset("-08:00"),
        tcg: list.indexOf('TCG') !== -1
      });
    }
    return results;
  })();

  if (settings.modules.enable_cloud_replay) {
    redis = require('redis');
    zlib = require('zlib');
    redisdb = redis.createClient({
      host: "127.0.0.1",
      port: settings.modules.redis_port
    });
  }

  if (settings.modules.enable_windbot) {
    settings.modules.windbots = require('./windbot/bots.json').windbots;
  }

  ygopro = require('./ygopro.js');

  if (settings.modules.enable_websocket_roomlist) {
    roomlist = require('./roomlist.js');
  }

  users_cache = {};

  get_memory_usage = function() {
    var actualFree, buffers, cached, free, line, lines, percentUsed, prc_free, total;
    prc_free = spawnSync("free", []);
    if (prc_free.stdout) {
      lines = prc_free.stdout.toString().split(/\n/g);
      line = lines[1].split(/\s+/);
      total = parseInt(line[1], 10);
      free = parseInt(line[3], 10);
      buffers = parseInt(line[5], 10);
      cached = parseInt(line[6], 10);
      actualFree = free + buffers + cached;
      percentUsed = parseFloat(((1 - (actualFree / total)) * 100).toFixed(2));
    } else {
      percentUsed = 0;
    }
    return percentUsed;
  };

  Graveyard = [];

  tribute = function(socket) {
    setTimeout((function(socket) {
      Graveyard.push(socket);
    })(socket), 3000);
  };

  setInterval(function() {
    var fuck, i, j, k, l, len, len1, ref, you;
    for (i = k = 0, len = Graveyard.length; k < len; i = ++k) {
      fuck = Graveyard[i];
      if (Graveyard[i]) {
        Graveyard[i].destroy();
      }
      ref = Graveyard[i];
      for (j = l = 0, len1 = ref.length; l < len1; j = ++l) {
        you = ref[j];
        Graveyard[i][j] = null;
      }
      Graveyard[i] = null;
    }
    Graveyard = [];
  }, 3000);

  Cloud_replay_ids = [];

  ROOM_all = [];

  ROOM_players_oppentlist = {};

  ROOM_players_banned = [];

  ROOM_ban_player = function(name, ip, reason, countadd) {
    var bannedplayer, bantime;
    if (countadd == null) {
      countadd = 1;
    }
    bannedplayer = _.find(ROOM_players_banned, function(bannedplayer) {
      return ip === bannedplayer.ip;
    });
    if (bannedplayer) {
      bannedplayer.count = bannedplayer.count + countadd;
      bantime = bannedplayer.count > 3 ? Math.pow(2, bannedplayer.count - 3) * 2 : 0;
      bannedplayer.time = moment() < bannedplayer.time ? moment(bannedplayer.time).add(bantime, 'm') : moment().add(bantime, 'm');
      if (!_.find(bannedplayer.reasons, function(bannedreason) {
        return bannedreason === reason;
      })) {
        bannedplayer.reasons.push(reason);
      }
      bannedplayer.need_tip = true;
    } else {
      bannedplayer = {
        "ip": ip,
        "time": moment(),
        "count": countadd,
        "reasons": [reason],
        "need_tip": true
      };
      ROOM_players_banned.push(bannedplayer);
    }
  };

  ROOM_find_or_create_by_name = function(name, player_ip) {
    var room;
    if (settings.modules.enable_random_duel && (name === '' || name.toUpperCase() === 'S' || name.toUpperCase() === 'M' || name.toUpperCase() === 'T')) {
      return ROOM_find_or_create_random(name.toUpperCase(), player_ip);
    }
    if (room = ROOM_find_by_name(name)) {
      return room;
    } else if (get_memory_usage() >= 90) {
      return null;
    } else {
      return new Room(name);
    }
  };

  ROOM_find_or_create_random = function(type, player_ip) {
    var bannedplayer, max_player, name, playerbanned, result;
    bannedplayer = _.find(ROOM_players_banned, function(bannedplayer) {
      return player_ip === bannedplayer.ip;
    });
    if (bannedplayer) {
      if (bannedplayer.count > 6 && moment() < bannedplayer.time) {
        return {
          "error": "因为您近期在游戏中多次" + (bannedplayer.reasons.join('、')) + "，您已被禁止使用随机对战功能，将在" + (moment(bannedplayer.time).fromNow(true)) + "后解封"
        };
      }
      if (bannedplayer.count > 3 && moment() < bannedplayer.time && bannedplayer.need_tip) {
        bannedplayer.need_tip = false;
        return {
          "error": "因为您近期在游戏中" + (bannedplayer.reasons.join('、')) + "，在" + (moment(bannedplayer.time).fromNow(true)) + "内您随机对战时只能遇到其他违规玩家"
        };
      } else if (bannedplayer.need_tip) {
        bannedplayer.need_tip = false;
        return {
          "error": "系统检测到您近期在游戏中" + (bannedplayer.reasons.join('、')) + "，若您违规超过3次，将受到惩罚"
        };
      } else if (bannedplayer.count > 2) {
        bannedplayer.need_tip = true;
      }
    }
    max_player = type === 'T' ? 4 : 2;
    playerbanned = bannedplayer && bannedplayer.count > 3 && moment() < bannedplayer.time;
    result = _.find(ROOM_all, function(room) {
      return room && room.random_type !== '' && !room.started && ((type === '' && room.random_type !== 'T') || room.random_type === type) && room.get_playing_player().length < max_player && (room.get_host() === null || room.get_host().remoteAddress !== ROOM_players_oppentlist[player_ip]) && (playerbanned === room.deprecated);
    });
    if (result) {
      result.welcome = '对手已经在等你了，开始决斗吧！';
    } else {
      type = type ? type : 'S';
      name = type + ',RANDOM#' + Math.floor(Math.random() * 100000);
      result = new Room(name);
      result.random_type = type;
      result.max_player = max_player;
      result.welcome = '已建立随机对战房间，正在等待对手！';
      result.deprecated = playerbanned;
    }
    if (result.random_type === 'M') {
      result.welcome = result.welcome + '\n您进入了比赛模式的房间，我们推荐使用竞技卡组！';
    }
    return result;
  };

  ROOM_find_by_name = function(name) {
    var result;
    result = _.find(ROOM_all, function(room) {
      return room && room.name === name;
    });
    return result;
  };

  ROOM_find_by_port = function(port) {
    return _.find(ROOM_all, function(room) {
      return room && room.port === port;
    });
  };

  ROOM_validate = function(name) {
    var client_name, client_name_and_pass, client_pass;
    client_name_and_pass = name.split('$', 2);
    client_name = client_name_and_pass[0];
    client_pass = client_name_and_pass[1];
    if (!client_pass) {
      return true;
    }
    return !_.find(ROOM_all, function(room) {
      var room_name, room_name_and_pass, room_pass;
      if (!room) {
        return false;
      }
      room_name_and_pass = room.name.split('$', 2);
      room_name = room_name_and_pass[0];
      room_pass = room_name_and_pass[1];
      return client_name === room_name && client_pass !== room_pass;
    });
  };

  Room = (function() {
    function Room(name, hostinfo) {
      var draw_count, error1, lflist, param, rule, start_hand, start_lp, time_limit;
      this.hostinfo = hostinfo;
      this.name = name;
      this.alive = true;
      this.players = [];
      this.player_datas = [];
      this.status = 'starting';
      this.started = false;
      this.established = false;
      this.watcher_buffers = [];
      this.recorder_buffers = [];
      this.cloud_replay_id = Math.floor(Math.random() * 100000000);
      this.watchers = [];
      this.random_type = '';
      this.welcome = '';
      ROOM_all.push(this);
      this.hostinfo || (this.hostinfo = {
        lflist: _.findIndex(settings.lflist, function(list) {
          return !list.tcg && list.date.isBefore();
        }),
        rule: settings.modules.enable_TCG_as_default ? 2 : 0,
        mode: 0,
        enable_priority: false,
        no_check_deck: false,
        no_shuffle_deck: false,
        start_lp: 8000,
        start_hand: 5,
        draw_count: 1,
        time_limit: 180,
        replay_mode: settings.modules.tournament_mode.enabled ? 1 : 0
      });
      if (name.slice(0, 2) === 'M#') {
        this.hostinfo.mode = 1;
      } else if (name.slice(0, 2) === 'T#') {
        this.hostinfo.mode = 2;
        this.hostinfo.start_lp = 16000;
      } else if ((param = name.match(/^(\d)(\d)(T|F)(T|F)(T|F)(\d+),(\d+),(\d+)/i))) {
        this.hostinfo.rule = parseInt(param[1]);
        this.hostinfo.mode = parseInt(param[2]);
        this.hostinfo.enable_priority = param[3] === 'T';
        this.hostinfo.no_check_deck = param[4] === 'T';
        this.hostinfo.no_shuffle_deck = param[5] === 'T';
        this.hostinfo.start_lp = parseInt(param[6]);
        this.hostinfo.start_hand = parseInt(param[7]);
        this.hostinfo.draw_count = parseInt(param[8]);
      } else if (((param = name.match(/(.+)#/)) !== null) && ((param[1].length <= 2 && param[1].match(/(S|N|M|T)(0|1|2|T|A)/i)) || (param[1].match(/^(S|N|M|T)(0|1|2|O|T|A)(0|1|O|T)/i)))) {
        rule = param[1].toUpperCase();
        switch (rule.charAt(0)) {
          case "M":
          case "1":
            this.hostinfo.mode = 1;
            break;
          case "T":
          case "2":
            this.hostinfo.mode = 2;
            this.hostinfo.start_lp = 16000;
            break;
          default:
            this.hostinfo.mode = 0;
        }
        switch (rule.charAt(1)) {
          case "0":
          case "O":
            this.hostinfo.rule = 0;
            break;
          case "1":
          case "T":
            this.hostinfo.rule = 1;
            break;
          default:
            this.hostinfo.rule = 2;
        }
        switch (rule.charAt(2)) {
          case "1":
          case "T":
            this.hostinfo.lflist = _.findIndex(settings.lflist, function(list) {
              return list.tcg && list.date.isBefore();
            });
            break;
          default:
            this.hostinfo.lflist = _.findIndex(settings.lflist, function(list) {
              return !list.tcg && list.date.isBefore();
            });
        }
        if ((param = parseInt(rule.charAt(3).match(/\d/))) >= 0) {
          this.hostinfo.time_limit = param * 60;
        }
        switch (rule.charAt(4)) {
          case "T":
          case "1":
            this.hostinfo.enable_priority = true;
            break;
          default:
            this.hostinfo.enable_priority = false;
        }
        switch (rule.charAt(5)) {
          case "T":
          case "1":
            this.hostinfo.no_check_deck = true;
            break;
          default:
            this.hostinfo.no_check_deck = false;
        }
        switch (rule.charAt(6)) {
          case "T":
          case "1":
            this.hostinfo.no_shuffle_deck = true;
            break;
          default:
            this.hostinfo.no_shuffle_deck = false;
        }
        if ((param = parseInt(rule.charAt(7).match(/\d/))) > 0) {
          this.hostinfo.start_lp = param * 4000;
        }
        if ((param = parseInt(rule.charAt(8).match(/\d/))) > 0) {
          this.hostinfo.start_hand = param;
        }
        if ((param = parseInt(rule.charAt(9).match(/\d/))) >= 0) {
          this.hostinfo.draw_count = param;
        }
      } else if ((param = name.match(/(.+)#/)) !== null) {
        rule = param[1].toUpperCase();
        if (rule.match(/(^|，|,)(M|MATCH)(，|,|$)/)) {
          this.hostinfo.mode = 1;
        }
        if (rule.match(/(^|，|,)(T|TAG)(，|,|$)/)) {
          this.hostinfo.mode = 2;
          this.hostinfo.start_lp = 16000;
        }
        if (rule.match(/(^|，|,)(TCGONLY|TO)(，|,|$)/)) {
          this.hostinfo.rule = 1;
          this.hostinfo.lflist = _.findIndex(settings.lflist, function(list) {
            return list.tcg && list.date.isBefore();
          });
        }
        if (rule.match(/(^|，|,)(OCGONLY|OO)(，|,|$)/)) {
          this.hostinfo.rule = 0;
        }
        if (rule.match(/(^|，|,)(OT|TCG)(，|,|$)/)) {
          this.hostinfo.rule = 2;
        }
        if ((param = rule.match(/(^|，|,)LP(\d+)(，|,|$)/))) {
          start_lp = parseInt(param[2]);
          if (start_lp <= 0) {
            start_lp = 1;
          }
          if (start_lp >= 99999) {
            start_lp = 99999;
          }
          this.hostinfo.start_lp = start_lp;
        }
        if ((param = rule.match(/(^|，|,)(TIME|TM|TI)(\d+)(，|,|$)/))) {
          time_limit = parseInt(param[3]);
          if (time_limit < 0) {
            time_limit = 180;
          }
          if (time_limit >= 1 && time_limit <= 60) {
            time_limit = time_limit * 60;
          }
          if (time_limit >= 999) {
            time_limit = 999;
          }
          this.hostinfo.time_limit = time_limit;
        }
        if ((param = rule.match(/(^|，|,)(START|ST)(\d+)(，|,|$)/))) {
          start_hand = parseInt(param[3]);
          if (start_hand <= 0) {
            start_hand = 1;
          }
          if (start_hand >= 40) {
            start_hand = 40;
          }
          this.hostinfo.start_hand = start_hand;
        }
        if ((param = rule.match(/(^|，|,)(DRAW|DR)(\d+)(，|,|$)/))) {
          draw_count = parseInt(param[3]);
          if (draw_count >= 35) {
            draw_count = 35;
          }
          this.hostinfo.draw_count = draw_count;
        }
        if ((param = rule.match(/(^|，|,)(LFLIST|LF)(\d+)(，|,|$)/))) {
          lflist = parseInt(param[3]) - 1;
          this.hostinfo.lflist = lflist;
        }
        if (rule.match(/(^|，|,)(NOLFLIST|NF)(，|,|$)/)) {
          this.hostinfo.lflist = -1;
        }
        if (rule.match(/(^|，|,)(NOUNIQUE|NU)(，|,|$)/)) {
          this.hostinfo.rule = 3;
        }
        if (rule.match(/(^|，|,)(NOCHECK|NC)(，|,|$)/)) {
          this.hostinfo.no_check_deck = true;
        }
        if (rule.match(/(^|，|,)(NOSHUFFLE|NS)(，|,|$)/)) {
          this.hostinfo.no_shuffle_deck = true;
        }
        if (rule.match(/(^|，|,)(IGPRIORITY|PR)(，|,|$)/)) {
          this.hostinfo.enable_priority = true;
        }
      }
      param = [0, this.hostinfo.lflist, this.hostinfo.rule, this.hostinfo.mode, (this.hostinfo.enable_priority ? 'T' : 'F'), (this.hostinfo.no_check_deck ? 'T' : 'F'), (this.hostinfo.no_shuffle_deck ? 'T' : 'F'), this.hostinfo.start_lp, this.hostinfo.start_hand, this.hostinfo.draw_count, this.hostinfo.time_limit, this.hostinfo.replay_mode];
      try {
        this.process = spawn('./ygopro', param, {
          cwd: settings.ygopro_path
        });
        this.process.on('exit', (function(_this) {
          return function(code) {
            if (!_this.disconnector) {
              _this.disconnector = 'server';
            }
            _this["delete"]();
          };
        })(this));
        this.process.stdout.setEncoding('utf8');
        this.process.stdout.once('data', (function(_this) {
          return function(data) {
            _this.established = true;
            if (!_this["private"] && settings.modules.enable_websocket_roomlist) {
              roomlist.create(_this);
            }
            _this.port = parseInt(data);
            _.each(_this.players, function(player) {
              player.server.connect(_this.port, '127.0.0.1', function() {
                var buffer, k, len, ref;
                ref = player.pre_establish_buffers;
                for (k = 0, len = ref.length; k < len; k++) {
                  buffer = ref[k];
                  player.server.write(buffer);
                }
                player.established = true;
                player.pre_establish_buffers = [];
              });
            });
            if (_this.windbot) {
              request.get("http://127.0.0.1:2399/?name=" + (encodeURIComponent(_this.windbot.name)) + "&deck=" + (encodeURIComponent(_this.windbot.deck)) + "&host=127.0.0.1&port=" + _this.port + "&dialog=" + (encodeURIComponent(_this.windbot.dialog)) + "&version=" + settings.version);
            }
          };
        })(this));
        this.process.stderr.on('data', (function(_this) {
          return function(data) {
            data = "Debug: " + data;
            data = data.replace(/\n$/, "");
            log.info("YGOPRO " + data);
            ygopro.stoc_send_chat_to_room(_this, data, ygopro.constants.COLORS.RED);
            _this.has_ygopro_error = true;
          };
        })(this));
      } catch (error1) {
        this.error = "建立房间失败，请重试";
      }
    }

    Room.prototype["delete"] = function() {
      var index, log_rep_id, player_ips, player_names, recorder_buffer, replay_id;
      if (this.deleted) {
        return;
      }
      if (this.player_datas.length && settings.modules.enable_cloud_replay) {
        replay_id = this.cloud_replay_id;
        if (this.has_ygopro_error) {
          log_rep_id = true;
        }
        player_names = this.player_datas[0].name + (this.player_datas[2] ? "+" + this.player_datas[2].name : "") + " VS " + (this.player_datas[1] ? this.player_datas[1].name : "AI") + (this.player_datas[3] ? "+" + this.player_datas[3].name : "");
        player_ips = [];
        _.each(this.player_datas, function(player) {
          player_ips.push(player.ip);
        });
        recorder_buffer = Buffer.concat(this.recorder_buffers);
        zlib.deflate(recorder_buffer, function(err, replay_buffer) {
          var date_time, recorded_ip;
          replay_buffer = replay_buffer.toString('binary');
          date_time = moment().format('YYYY-MM-DD HH:mm:ss');
          redisdb.hmset("replay:" + replay_id, "replay_id", replay_id, "replay_buffer", replay_buffer, "player_names", player_names, "date_time", date_time);
          if (!log_rep_id) {
            redisdb.expire("replay:" + replay_id, 60 * 60 * 24);
          }
          recorded_ip = [];
          _.each(player_ips, function(player_ip) {
            if (_.contains(recorded_ip, player_ip)) {
              return;
            }
            recorded_ip.push(player_ip);
            redisdb.lpush(player_ip + ":replays", replay_id);
          });
          if (log_rep_id) {
            log.info("error replay: R#" + replay_id);
          }
        });
      }
      this.watcher_buffers = [];
      this.recorder_buffers = [];
      this.players = [];
      if (this.watcher) {
        this.watcher.end();
      }
      this.deleted = true;
      index = _.indexOf(ROOM_all, this);
      if (index !== -1) {
        ROOM_all[index] = null;
      }
      if (!this["private"] && !this.started && this.established && settings.modules.enable_websocket_roomlist) {
        roomlist["delete"](this.name);
      }
    };

    Room.prototype.get_playing_player = function() {
      var playing_player;
      playing_player = [];
      _.each(this.players, function(player) {
        if (player.pos < 4) {
          playing_player.push(player);
        }
      });
      return playing_player;
    };

    Room.prototype.get_host = function() {
      var host_player;
      host_player = null;
      _.each(this.players, function(player) {
        if (player.is_host) {
          host_player = player;
        }
      });
      return host_player;
    };

    Room.prototype.connect = function(client) {
      var host_player;
      this.players.push(client);
      client.ip = client.remoteAddress;
      if (this.random_type) {
        host_player = this.get_host();
        if (host_player && (host_player !== client)) {
          ROOM_players_oppentlist[host_player.remoteAddress] = client.remoteAddress;
          ROOM_players_oppentlist[client.remoteAddress] = host_player.remoteAddress;
        } else {
          ROOM_players_oppentlist[client.remoteAddress] = null;
        }
      }
      if (this.established) {
        if (!this["private"] && !this.started && settings.modules.enable_websocket_roomlist) {
          roomlist.update(this);
        }
        client.server.connect(this.port, '127.0.0.1', function() {
          var buffer, k, len, ref;
          ref = client.pre_establish_buffers;
          for (k = 0, len = ref.length; k < len; k++) {
            buffer = ref[k];
            client.server.write(buffer);
          }
          client.established = true;
          client.pre_establish_buffers = [];
        });
      }
    };

    Room.prototype.disconnect = function(client, error) {
      var index;
      if (client.is_post_watcher) {
        ygopro.stoc_send_chat_to_room(this, (client.name + " 退出了观战") + (error ? ": " + error : ''));
        index = _.indexOf(this.watchers, client);
        if (index !== -1) {
          this.watchers.splice(index, 1);
        }
      } else {
        index = _.indexOf(this.players, client);
        if (index !== -1) {
          this.players.splice(index, 1);
        }
        if (this.started && this.disconnector !== 'server' && this.random_type) {
          ROOM_ban_player(client.name, client.ip, "强退");
        }
        if (this.players.length) {
          ygopro.stoc_send_chat_to_room(this, (client.name + " 离开了游戏") + (error ? ": " + error : ''));
          if (!this["private"] && !this.started && settings.modules.enable_websocket_roomlist) {
            roomlist.update(this);
          }
        } else {
          this.process.kill();
          this["delete"]();
        }
      }
    };

    return Room;

  })();

  net.createServer(function(client) {
    var server;
    server = new net.Socket();
    client.server = server;
    client.setTimeout(300000);
    client.on('close', function(had_error) {
      var room;
      room = ROOM_all[client.rid];
      tribute(client);
      if (!client.closed) {
        client.closed = true;
        if (room) {
          room.disconnect(client);
        }
      }
      server.end();
    });
    client.on('error', function(error) {
      var room;
      room = ROOM_all[client.rid];
      tribute(client);
      if (!client.closed) {
        client.closed = error;
        if (room) {
          room.disconnect(client, error);
        }
      }
      server.end();
    });
    client.on('timeout', function() {
      server.end();
    });
    server.on('close', function(had_error) {
      var room;
      room = ROOM_all[client.rid];
      tribute(server);
      if (room) {
        room.disconnector = 'server';
      }
      if (!server.closed) {
        server.closed = true;
      }
      if (!client.closed) {
        ygopro.stoc_send_chat(client, "服务器关闭了连接", ygopro.constants.COLORS.RED);
        client.end();
      }
    });
    server.on('error', function(error) {
      var room;
      room = ROOM_all[client.rid];
      tribute(server);
      if (room) {
        room.disconnector = 'server';
      }
      server.closed = error;
      if (!client.closed) {
        ygopro.stoc_send_chat(client, "服务器错误: " + error, ygopro.constants.COLORS.RED);
        client.end();
      }
    });
    if (settings.modules.enable_cloud_replay) {
      client.open_cloud_replay = function(err, replay) {
        var buffer;
        if (err || !replay) {
          ygopro.stoc_die(client, "没有找到录像");
          return;
        }
        redisdb.expire("replay:" + replay.replay_id, 60 * 60 * 48);
        buffer = new Buffer(replay.replay_buffer, 'binary');
        zlib.unzip(buffer, function(err, replay_buffer) {
          if (err) {
            log.info("cloud replay unzip error: " + err);
            ygopro.stoc_send_chat(client, "播放录像出错", ygopro.constants.COLORS.RED);
            client.end();
            return;
          }
          ygopro.stoc_send_chat(client, "正在观看云录像：R#" + replay.replay_id + " " + replay.player_names + " " + replay.date_time, ygopro.constants.COLORS.BABYBLUE);
          client.write(replay_buffer);
          client.end();
        });
      };
    }
    client.pre_establish_buffers = new Array();
    client.on('data', function(data) {
      var b, buffer, cancel, ctos_buffer, ctos_message_length, ctos_proto, datas, k, l, len, len1, looplimit, room, struct;
      if (client.is_post_watcher) {
        room = ROOM_all[client.rid];
        if (room) {
          room.watcher.write(data);
        }
      } else {
        ctos_buffer = new Buffer(0);
        ctos_message_length = 0;
        ctos_proto = 0;
        ctos_buffer = Buffer.concat([ctos_buffer, data], ctos_buffer.length + data.length);
        datas = [];
        looplimit = 0;
        while (true) {
          if (ctos_message_length === 0) {
            if (ctos_buffer.length >= 2) {
              ctos_message_length = ctos_buffer.readUInt16LE(0);
            } else {
              break;
            }
          } else if (ctos_proto === 0) {
            if (ctos_buffer.length >= 3) {
              ctos_proto = ctos_buffer.readUInt8(2);
            } else {
              break;
            }
          } else {
            if (ctos_buffer.length >= 2 + ctos_message_length) {
              cancel = false;
              if (ygopro.ctos_follows[ctos_proto]) {
                b = ctos_buffer.slice(3, ctos_message_length - 1 + 3);
                if (struct = ygopro.structs[ygopro.proto_structs.CTOS[ygopro.constants.CTOS[ctos_proto]]]) {
                  struct._setBuff(b);
                  if (ygopro.ctos_follows[ctos_proto].synchronous) {
                    cancel = ygopro.ctos_follows[ctos_proto].callback(b, _.clone(struct.fields), client, server);
                  } else {
                    ygopro.ctos_follows[ctos_proto].callback(b, _.clone(struct.fields), client, server);
                  }
                } else {
                  ygopro.ctos_follows[ctos_proto].callback(b, null, client, server);
                }
              }
              if (!cancel) {
                datas.push(ctos_buffer.slice(0, 2 + ctos_message_length));
              }
              ctos_buffer = ctos_buffer.slice(2 + ctos_message_length);
              ctos_message_length = 0;
              ctos_proto = 0;
            } else {
              break;
            }
          }
          looplimit++;
          if (looplimit > 800) {
            log.info("error ctos", client.name);
            server.end();
            break;
          }
        }
        if (client.established) {
          for (k = 0, len = datas.length; k < len; k++) {
            buffer = datas[k];
            server.write(buffer);
          }
        } else {
          for (l = 0, len1 = datas.length; l < len1; l++) {
            buffer = datas[l];
            client.pre_establish_buffers.push(buffer);
          }
        }
      }
    });
    server.on('data', function(data) {
      var b, buffer, cancel, datas, k, len, looplimit, stanzas, stoc_buffer, stoc_message_length, stoc_proto, struct;
      stoc_buffer = new Buffer(0);
      stoc_message_length = 0;
      stoc_proto = 0;
      stoc_buffer = Buffer.concat([stoc_buffer, data], stoc_buffer.length + data.length);
      datas = [];
      looplimit = 0;
      while (true) {
        if (stoc_message_length === 0) {
          if (stoc_buffer.length >= 2) {
            stoc_message_length = stoc_buffer.readUInt16LE(0);
          } else {
            break;
          }
        } else if (stoc_proto === 0) {
          if (stoc_buffer.length >= 3) {
            stoc_proto = stoc_buffer.readUInt8(2);
          } else {
            break;
          }
        } else {
          if (stoc_buffer.length >= 2 + stoc_message_length) {
            cancel = false;
            stanzas = stoc_proto;
            if (ygopro.stoc_follows[stoc_proto]) {
              b = stoc_buffer.slice(3, stoc_message_length - 1 + 3);
              if (struct = ygopro.structs[ygopro.proto_structs.STOC[ygopro.constants.STOC[stoc_proto]]]) {
                struct._setBuff(b);
                if (ygopro.stoc_follows[stoc_proto].synchronous) {
                  cancel = ygopro.stoc_follows[stoc_proto].callback(b, _.clone(struct.fields), client, server);
                } else {
                  ygopro.stoc_follows[stoc_proto].callback(b, _.clone(struct.fields), client, server);
                }
              } else {
                if (ygopro.stoc_follows[stoc_proto].synchronous) {
                  cancel = ygopro.stoc_follows[stoc_proto].callback(b, null, client, server);
                } else {
                  ygopro.stoc_follows[stoc_proto].callback(b, null, client, server);
                }
              }
            }
            if (!cancel) {
              datas.push(stoc_buffer.slice(0, 2 + stoc_message_length));
            }
            stoc_buffer = stoc_buffer.slice(2 + stoc_message_length);
            stoc_message_length = 0;
            stoc_proto = 0;
          } else {
            break;
          }
        }
        looplimit++;
        if (looplimit > 800) {
          log.info("error stoc", client.name);
          server.end();
          break;
        }
      }
      for (k = 0, len = datas.length; k < len; k++) {
        buffer = datas[k];
        client.write(buffer);
      }
    });
  }).listen(settings.port, function() {
    log.info("server started", settings.port);
  });

  ygopro.ctos_follow('PLAYER_INFO', true, function(buffer, info, client, server) {
    var name, struct;
    name = info.name.split("$")[0];
    struct = ygopro.structs["CTOS_PlayerInfo"];
    struct._setBuff(buffer);
    struct.set("name", name);
    buffer = struct.buffer;
    client.name = name;
    return false;
  });

  ygopro.ctos_follow('JOIN_GAME', false, function(buffer, info, client, server) {
    var check, decrypted_buffer, finish, i, id, k, l, len, len1, name, ref, ref1, replay_id, room, secret, struct, windbot;
    if (settings.modules.stop) {
      ygopro.stoc_die(client, settings.modules.stop);
    } else if (info.pass.toUpperCase() === "R" && settings.modules.enable_cloud_replay) {
      ygopro.stoc_send_chat(client, "以下是您近期的云录像，密码处输入 R#录像编号 即可观看", ygopro.constants.COLORS.BABYBLUE);
      redisdb.lrange(client.remoteAddress + ":replays", 0, 2, function(err, result) {
        _.each(result, function(replay_id, id) {
          redisdb.hgetall("replay:" + replay_id, function(err, replay) {
            if (err || !replay) {
              if (err) {
                log.info("cloud replay getall error: " + err);
              }
              return;
            }
            ygopro.stoc_send_chat(client, "<" + (id - 0 + 1) + "> R#" + replay_id + " " + replay.player_names + " " + replay.date_time, ygopro.constants.COLORS.BABYBLUE);
          });
        });
      });
      setTimeout((function() {
        ygopro.stoc_send(client, 'ERROR_MSG', {
          msg: 1,
          code: 2
        });
        client.end();
      }), 500);
    } else if (info.pass.slice(0, 2).toUpperCase() === "R#" && settings.modules.enable_cloud_replay) {
      replay_id = info.pass.split("#")[1];
      if (replay_id > 0 && replay_id <= 9) {
        redisdb.lindex(client.remoteAddress + ":replays", replay_id - 1, function(err, replay_id) {
          if (err || !replay_id) {
            if (err) {
              log.info("cloud replay replayid error: " + err);
            }
            ygopro.stoc_die(client, "没有找到录像");
            return;
          }
          redisdb.hgetall("replay:" + replay_id, client.open_cloud_replay);
        });
      } else if (replay_id) {
        redisdb.hgetall("replay:" + replay_id, client.open_cloud_replay);
      } else {
        ygopro.stoc_die(client, "没有找到录像");
      }
    } else if (info.pass.toUpperCase() === "W" && settings.modules.enable_cloud_replay) {
      replay_id = Cloud_replay_ids[Math.floor(Math.random() * Cloud_replay_ids.length)];
      redisdb.hgetall("replay:" + replay_id, client.open_cloud_replay);
    } else if (info.version !== settings.version && info.version !== 4921) {
      ygopro.stoc_send_chat(client, settings.modules.update, ygopro.constants.COLORS.RED);
      ygopro.stoc_send(client, 'ERROR_MSG', {
        msg: 4,
        code: settings.version
      });
      client.end();
    } else if (!info.pass.length && !settings.modules.enable_random_duel) {
      ygopro.stoc_die(client, "房间名为空，请填写主机密码");
    } else if (settings.modules.enable_windbot && info.pass.slice(0, 2) === 'AI') {
      if (info.pass.length > 3 && info.pass.slice(0, 3) === 'AI#' || info.pass.slice(0, 3) === 'AI_') {
        name = info.pass.slice(3);
        windbot = _.sample(_.filter(settings.modules.windbots, function(w) {
          return w.name === name || w.deck === name;
        }));
        if (!windbot) {
          ygopro.stoc_die(client, '主机密码不正确 (Invalid Windbot Name)');
          return;
        }
      } else {
        windbot = _.sample(settings.modules.windbots);
      }
      if (info.version === 4921) {
        info.version = settings.version;
        struct = ygopro.structs["CTOS_JoinGame"];
        struct._setBuff(buffer);
        struct.set("version", info.version);
        buffer = struct.buffer;
        ygopro.stoc_send_chat(client, "您的版本号过低，可能出现未知问题，电脑用户请升级版本，YGOMobile用户请等待作者更新", ygopro.constants.COLORS.BABYBLUE);
      }
      room = ROOM_find_or_create_by_name('AI#' + Math.floor(Math.random() * 100000));
      if (!room) {
        ygopro.stoc_die(client, "服务器已经爆满，请稍候再试");
      } else if (room.error) {
        ygopro.stoc_die(client, room.error);
      } else {
        room.windbot = windbot;
        room["private"] = true;
        client.rid = _.indexOf(ROOM_all, room);
        room.connect(client);
      }
    } else if (info.pass.length && settings.modules.mycard_auth) {
      ygopro.stoc_send_chat(client, '正在读取用户信息...', ygopro.constants.COLORS.BABYBLUE);
      if (info.pass.length <= 8) {
        ygopro.stoc_die(client, '主机密码不正确 (Invalid Length)');
        return;
      }
      buffer = new Buffer(info.pass.slice(0, 8), 'base64');
      if (buffer.length !== 6) {
        ygopro.stoc_die(client, '主机密码不正确 (Invalid Payload Length)');
        return;
      }
      check = function(buf) {
        var checksum, i, k, ref;
        checksum = 0;
        for (i = k = 0, ref = buf.length; 0 <= ref ? k < ref : k > ref; i = 0 <= ref ? ++k : --k) {
          checksum += buf.readUInt8(i);
        }
        return (checksum & 0xFF) === 0;
      };
      finish = function(buffer) {
        var action, opt1, opt2, opt3, options;
        action = buffer.readUInt8(1) >> 4;
        if (buffer !== decrypted_buffer && (action === 1 || action === 2 || action === 4)) {
          ygopro.stoc_die(client, '主机密码不正确 (Unauthorized)');
          return;
        }
        switch (action) {
          case 1:
          case 2:
            name = crypto.createHash('md5').update(info.pass + client.name).digest('base64').slice(0, 10).replace('+', '-').replace('/', '_');
            if (ROOM_find_by_name(name)) {
              ygopro.stoc_die(client, '主机密码不正确 (Already Existed)');
              return;
            }
            opt1 = buffer.readUInt8(2);
            opt2 = buffer.readUInt16LE(3);
            opt3 = buffer.readUInt8(5);
            options = {
              lflist: 0,
              time_limit: 180,
              rule: (opt1 >> 5) & 3,
              mode: (opt1 >> 3) & 3,
              enable_priority: !!((opt1 >> 2) & 1),
              no_check_deck: !!((opt1 >> 1) & 1),
              no_shuffle_deck: !!(opt1 & 1),
              start_lp: opt2,
              start_hand: opt3 >> 4,
              draw_count: opt3 & 0xF
            };
            options.lflist = _.findIndex(settings.lflist, function(list) {
              return ((options.rule === 1) === list.tcg) && list.date.isBefore();
            });
            room = new Room(name, options);
            room.title = info.pass.slice(8).replace(String.fromCharCode(0xFEFF), ' ');
            room["private"] = action === 2;
            break;
          case 3:
            name = info.pass.slice(8);
            room = ROOM_find_by_name(name);
            if (!room) {
              ygopro.stoc_die(client, '主机密码不正确 (Not Found)');
              return;
            }
            break;
          case 4:
            room = ROOM_find_or_create_by_name('M#' + info.pass.slice(8));
            room["private"] = true;
            break;
          default:
            ygopro.stoc_die(client, '主机密码不正确 (Invalid Action)');
            return;
        }
        if (!room) {
          ygopro.stoc_die(client, "服务器已经爆满，请稍候再试");
        } else if (room.error) {
          ygopro.stoc_die(client, room.error);
        } else {
          client.rid = _.indexOf(ROOM_all, room);
          room.connect(client);
        }
      };
      if (id = users_cache[client.name]) {
        secret = id % 65535 + 1;
        decrypted_buffer = new Buffer(6);
        ref = [0, 2, 4];
        for (k = 0, len = ref.length; k < len; k++) {
          i = ref[k];
          decrypted_buffer.writeUInt16LE(buffer.readUInt16LE(i) ^ secret, i);
        }
        if (check(decrypted_buffer)) {
          return finish(decrypted_buffer);
        }
      }
      request({
        baseUrl: settings.modules.mycard_auth,
        url: '/users/' + encodeURIComponent(client.name) + '.json',
        qs: {
          api_key: 'dc7298a754828b3d26b709f035a0eeceb43e73cbd8c4fa8dec18951f8a95d2bc',
          api_username: client.name,
          skip_track_visit: true
        },
        json: true
      }, function(error, response, body) {
        var l, len1, ref1;
        if (body && body.user) {
          secret = body.user.id % 65535 + 1;
          decrypted_buffer = new Buffer(6);
          ref1 = [0, 2, 4];
          for (l = 0, len1 = ref1.length; l < len1; l++) {
            i = ref1[l];
            decrypted_buffer.writeUInt16LE(buffer.readUInt16LE(i) ^ secret, i);
          }
          if (check(decrypted_buffer)) {
            buffer = decrypted_buffer;
          }
        }
        if (!check(buffer)) {
          ygopro.stoc_die(client, '主机密码不正确 (Checksum Failed)');
          return;
        }
        users_cache[client.name] = body.user.id;
        return finish(buffer);
      });
    } else if (info.pass.length && !ROOM_validate(info.pass)) {
      ygopro.stoc_die(client, "房间密码不正确");
    } else if (_.indexOf(settings.ban.banned_user, client.name) > -1) {
      settings.ban.banned_ip.push(client.remoteAddress);
      log.warn("BANNED USER LOGIN", client.name, client.remoteAddress);
      ygopro.stoc_die(client, "您的账号已被封禁");
    } else if (_.indexOf(settings.ban.banned_ip, client.remoteAddress) > -1) {
      log.warn("BANNED IP LOGIN", client.name, client.remoteAddress);
      ygopro.stoc_die(client, "您的账号已被封禁");
    } else if (_.any(settings.ban.badword_level3, function(badword) {
      var regexp;
      regexp = new RegExp(badword, 'i');
      return name.match(regexp);
    }, name = client.name)) {
      log.warn("BAD NAME LEVEL 3", client.name, client.remoteAddress);
      ygopro.stoc_die(client, "您的用户名存在不适当的内容");
    } else if (_.any(settings.ban.badword_level2, function(badword) {
      var regexp;
      regexp = new RegExp(badword, 'i');
      return name.match(regexp);
    }, name = client.name)) {
      log.warn("BAD NAME LEVEL 2", client.name, client.remoteAddress);
      ygopro.stoc_die(client, "您的用户名存在不适当的内容");
    } else if (_.any(settings.ban.badword_level1, function(badword) {
      var regexp;
      regexp = new RegExp(badword, 'i');
      return name.match(regexp);
    }, name = client.name)) {
      log.warn("BAD NAME LEVEL 1", client.name, client.remoteAddress);
      ygopro.stoc_die(client, "您的用户名存在不适当的内容，请注意更改");
    } else {
      if (info.version === 4921) {
        info.version = settings.version;
        struct = ygopro.structs["CTOS_JoinGame"];
        struct._setBuff(buffer);
        struct.set("version", info.version);
        buffer = struct.buffer;
        ygopro.stoc_send_chat(client, "您的版本号过低，可能出现未知问题，电脑用户请升级版本，YGOMobile用户请等待作者更新", ygopro.constants.COLORS.BABYBLUE);
      }
      room = ROOM_find_or_create_by_name(info.pass, client.remoteAddress);
      if (!room) {
        ygopro.stoc_die(client, "服务器已经爆满，请稍候再试");
      } else if (room.error) {
        ygopro.stoc_die(client, room.error);
      } else if (room.started) {
        if (settings.modules.enable_halfway_watch) {
          client.rid = _.indexOf(ROOM_all, room);
          client.is_post_watcher = true;
          ygopro.stoc_send_chat_to_room(room, client.name + " 加入了观战");
          room.watchers.push(client);
          ygopro.stoc_send_chat(client, "观战中", ygopro.constants.COLORS.BABYBLUE);
          ref1 = room.watcher_buffers;
          for (l = 0, len1 = ref1.length; l < len1; l++) {
            buffer = ref1[l];
            client.write(buffer);
          }
        } else {
          ygopro.stoc_die(client, "决斗已开始，不允许观战");
        }
      } else {
        client.rid = _.indexOf(ROOM_all, room);
        room.connect(client);
      }
    }
  });

  ygopro.stoc_follow('JOIN_GAME', false, function(buffer, info, client, server) {
    var recorder, room, watcher;
    room = ROOM_all[client.rid];
    if (!room) {
      return;
    }
    if (settings.modules.welcome) {
      ygopro.stoc_send_chat(client, settings.modules.welcome, ygopro.constants.COLORS.GREEN);
    }
    if (room.welcome) {
      ygopro.stoc_send_chat(client, room.welcome, ygopro.constants.COLORS.BABYBLUE);
    }
    if (!room.recorder) {
      room.recorder = recorder = net.connect(room.port, function() {
        ygopro.ctos_send(recorder, 'PLAYER_INFO', {
          name: "Marshtomp"
        });
        ygopro.ctos_send(recorder, 'JOIN_GAME', {
          version: settings.version,
          gameid: 2577,
          some_unknown_mysterious_fucking_thing: 0,
          pass: ""
        });
        ygopro.ctos_send(recorder, 'HS_TOOBSERVER');
      });
      recorder.on('data', function(data) {
        room = ROOM_all[client.rid];
        if (!(room && settings.modules.enable_cloud_replay)) {
          return;
        }
        room.recorder_buffers.push(data);
      });
      recorder.on('error', function(error) {});
    }
    if (settings.modules.enable_halfway_watch && !room.watcher) {
      room.watcher = watcher = net.connect(room.port, function() {
        ygopro.ctos_send(watcher, 'PLAYER_INFO', {
          name: "the Big Brother"
        });
        ygopro.ctos_send(watcher, 'JOIN_GAME', {
          version: settings.version,
          gameid: 2577,
          some_unknown_mysterious_fucking_thing: 0,
          pass: ""
        });
        ygopro.ctos_send(watcher, 'HS_TOOBSERVER');
      });
      watcher.on('data', function(data) {
        var k, len, ref, w;
        room = ROOM_all[client.rid];
        if (!room) {
          return;
        }
        room.watcher_buffers.push(data);
        ref = room.watchers;
        for (k = 0, len = ref.length; k < len; k++) {
          w = ref[k];
          if (w) {
            w.write(data);
          }
        }
      });
      watcher.on('error', function(error) {});
    }
  });

  load_dialogues = function() {
    request({
      url: settings.modules.dialogues,
      json: true
    }, function(error, response, body) {
      if (_.isString(body)) {
        log.warn("dialogues bad json", body);
      } else if (error || !body) {
        log.warn('dialogues error', error, response);
      } else {
        nconf.myset(settings, "dialogues", body);
        log.info("dialogues loaded", _.size(body));
      }
    });
  };

  if (settings.modules.dialogues) {
    load_dialogues();
  }

  ygopro.stoc_follow('GAME_MSG', false, function(buffer, info, client, server) {
    var card, k, len, line, msg, playertype, pos, reason, ref, ref1, ref2, room, val;
    room = ROOM_all[client.rid];
    if (!room) {
      return;
    }
    msg = buffer.readInt8(0);
    if (msg >= 10 && msg < 30) {
      room.waiting_for_player = client;
      room.last_active_time = moment();
    }
    if (ygopro.constants.MSG[msg] === 'START') {
      playertype = buffer.readUInt8(1);
      client.is_first = !(playertype & 0xf);
      client.lp = room.hostinfo.start_lp;
    }
    if (ygopro.constants.MSG[msg] === 'WIN' && client.is_host) {
      pos = buffer.readUInt8(1);
      if (!(client.is_first || pos === 2)) {
        pos = 1 - pos;
      }
      reason = buffer.readUInt8(2);
      room.winner = pos;
    }
    if (ygopro.constants.MSG[msg] === 'DAMAGE' && client.is_host) {
      pos = buffer.readUInt8(1);
      if (!client.is_first) {
        pos = 1 - pos;
      }
      val = buffer.readInt32LE(2);
      room.dueling_players[pos].lp -= val;
      if ((0 < (ref = room.dueling_players[pos].lp) && ref <= 100)) {
        ygopro.stoc_send_chat_to_room(room, "你的生命已经如风中残烛了！", ygopro.constants.COLORS.PINK);
      }
    }
    if (ygopro.constants.MSG[msg] === 'RECOVER' && client.is_host) {
      pos = buffer.readUInt8(1);
      if (!client.is_first) {
        pos = 1 - pos;
      }
      val = buffer.readInt32LE(2);
      room.dueling_players[pos].lp += val;
    }
    if (ygopro.constants.MSG[msg] === 'LPUPDATE' && client.is_host) {
      pos = buffer.readUInt8(1);
      if (!client.is_first) {
        pos = 1 - pos;
      }
      val = buffer.readInt32LE(2);
      room.dueling_players[pos].lp = val;
    }
    if (ygopro.constants.MSG[msg] === 'PAY_LPCOST' && client.is_host) {
      pos = buffer.readUInt8(1);
      if (!client.is_first) {
        pos = 1 - pos;
      }
      val = buffer.readInt32LE(2);
      room.dueling_players[pos].lp -= val;
      if ((0 < (ref1 = room.dueling_players[pos].lp) && ref1 <= 100)) {
        ygopro.stoc_send_chat_to_room(room, "背水一战！", ygopro.constants.COLORS.PINK);
      }
    }
    if (settings.modules.dialogues) {
      if (ygopro.constants.MSG[msg] === 'SUMMONING' || ygopro.constants.MSG[msg] === 'SPSUMMONING') {
        card = buffer.readUInt32LE(1);
        if (settings.dialogues[card]) {
          ref2 = _.lines(settings.dialogues[card][Math.floor(Math.random() * settings.dialogues[card].length)]);
          for (k = 0, len = ref2.length; k < len; k++) {
            line = ref2[k];
            ygopro.stoc_send_chat(client, line, ygopro.constants.COLORS.PINK);
          }
        }
      }
    }
  });

  ygopro.ctos_follow('HS_KICK', true, function(buffer, info, client, server) {
    var k, len, player, ref, room;
    room = ROOM_all[client.rid];
    if (!room) {
      return;
    }
    ref = room.players;
    for (k = 0, len = ref.length; k < len; k++) {
      player = ref[k];
      if (player && player.pos === info.pos && player !== client) {
        client.kick_count = client.kick_count ? client.kick_count + 1 : 1;
        if (client.kick_count >= 5) {
          ygopro.stoc_send_chat_to_room(room, client.name + " 被系统请出了房间", ygopro.constants.COLORS.RED);
          ROOM_ban_player(player.name, player.ip, "挂房间");
          client.end();
          return true;
        }
        ygopro.stoc_send_chat_to_room(room, player.name + " 被请出了房间", ygopro.constants.COLORS.RED);
      }
    }
    return false;
  });

  ygopro.stoc_follow('TYPE_CHANGE', false, function(buffer, info, client, server) {
    var is_host, selftype;
    selftype = info.type & 0xf;
    is_host = ((info.type >> 4) & 0xf) !== 0;
    client.is_host = is_host;
    client.pos = selftype;
  });

  ygopro.stoc_follow('HS_PLAYER_CHANGE', false, function(buffer, info, client, server) {
    var is_ready, k, len, player, pos, ref, room;
    room = ROOM_all[client.rid];
    if (!(room && room.max_player && client.is_host)) {
      return;
    }
    pos = info.status >> 4;
    is_ready = (info.status & 0xf) === 9;
    if (pos < room.max_player) {
      room.ready_player_count_without_host = 0;
      ref = room.players;
      for (k = 0, len = ref.length; k < len; k++) {
        player = ref[k];
        if (player.pos === pos) {
          player.is_ready = is_ready;
        }
        if (!player.is_host) {
          room.ready_player_count_without_host += player.is_ready;
        }
      }
      if (room.ready_player_count_without_host >= room.max_player - 1) {
        setTimeout((function() {
          wait_room_start(ROOM_all[client.rid], 20);
        }), 1000);
      }
    }
  });

  wait_room_start = function(room, time) {
    var k, len, player, ref;
    if (!(!room || room.started || room.ready_player_count_without_host < room.max_player - 1)) {
      time -= 1;
      if (time) {
        if (!(time % 5)) {
          ygopro.stoc_send_chat_to_room(room, "" + (time <= 9 ? ' ' : '') + time + "秒后房主若不开始游戏将被请出房间", time <= 9 ? ygopro.constants.COLORS.RED : ygopro.constants.COLORS.LIGHTBLUE);
        }
        setTimeout((function() {
          wait_room_start(room, time);
        }), 1000);
      } else {
        ref = room.players;
        for (k = 0, len = ref.length; k < len; k++) {
          player = ref[k];
          if (player && player.is_host) {
            ROOM_ban_player(player.name, player.ip, "挂房间");
            ygopro.stoc_send_chat_to_room(room, player.name + " 被系统请出了房间", ygopro.constants.COLORS.RED);
            player.end();
          }
        }
      }
    }
  };

  ygopro.stoc_send_random_tip = function(client) {
    if (settings.modules.tips) {
      ygopro.stoc_send_chat(client, "Tip: " + settings.tips[Math.floor(Math.random() * settings.tips.length)]);
    }
  };

  ygopro.stoc_send_random_tip_to_room = function(room) {
    if (settings.modules.tips) {
      ygopro.stoc_send_chat_to_room(room, "Tip: " + settings.tips[Math.floor(Math.random() * settings.tips.length)]);
    }
  };

  load_tips = function() {
    request({
      url: settings.modules.tips,
      json: true
    }, function(error, response, body) {
      if (_.isString(body)) {
        log.warn("tips bad json", body);
      } else if (error || !body) {
        log.warn('tips error', error, response);
      } else {
        nconf.myset(settings, "tips", body);
        log.info("tips loaded", settings.tips.length);
      }
    });
  };

  if (settings.modules.tips) {
    load_tips();
    setInterval(function() {
      var k, len, room;
      for (k = 0, len = ROOM_all.length; k < len; k++) {
        room = ROOM_all[k];
        if (room && room.established) {
          if (!(room && room.started)) {
            ygopro.stoc_send_random_tip_to_room(room);
          }
        }
      }
    }, 30000);
  }

  if (settings.modules.mycard_auth && process.env.MYCARD_AUTH_DATABASE) {
    pg = require('pg');
    pg.connect(process.env.MYCARD_AUTH_DATABASE, function(error, client, done) {
      if (error) {
        throw error;
      }
      client.query('SELECT username, id from users', function(error, result) {
        var k, len, ref, row;
        if (error) {
          throw error;
        }
        done();
        ref = result.rows;
        for (k = 0, len = ref.length; k < len; k++) {
          row = ref[k];
          users_cache[row.username] = row.id;
        }
        console.log("users loaded", _.keys(users_cache).length);
      });
    });
  }

  ygopro.stoc_follow('DUEL_START', false, function(buffer, info, client, server) {
    var k, len, player, ref, room;
    room = ROOM_all[client.rid];
    if (!room) {
      return;
    }
    if (!room.started) {
      room.started = true;
      if (settings.modules.enable_websocket_roomlist && !room["private"]) {
        roomlist["delete"](room.name);
      }
      room.dueling_players = [];
      ref = room.players;
      for (k = 0, len = ref.length; k < len; k++) {
        player = ref[k];
        if (!(player.pos !== 7)) {
          continue;
        }
        room.dueling_players[player.pos] = player;
        room.player_datas.push({
          ip: player.remoteAddress,
          name: player.name
        });
        if (room.windbot) {
          room.dueling_players[1 - player.pos] = {};
        }
      }
    }
    if (settings.modules.tips) {
      ygopro.stoc_send_random_tip(client);
    }
  });

  ygopro.ctos_follow('CHAT', true, function(buffer, info, client, server) {
    var cancel, msg, oldmsg, room, struct;
    room = ROOM_all[client.rid];
    if (!room) {
      return;
    }
    msg = _.trim(info.msg);
    cancel = _.startsWith(msg, "/");
    if (!(cancel || !room.random_type)) {
      room.last_active_time = moment();
    }
    switch (msg) {
      case '/help':
        ygopro.stoc_send_chat(client, "YGOSrv233 指令帮助");
        ygopro.stoc_send_chat(client, "/help 显示这个帮助信息");
        ygopro.stoc_send_chat(client, "/roomname 显示当前房间的名字");
        if (settings.modules.tips) {
          ygopro.stoc_send_chat(client, "/tip 显示一条提示");
        }
        break;
      case '/tip':
        if (settings.modules.tips) {
          ygopro.stoc_send_random_tip(client);
        }
        break;
      case '/roomname':
        if (room) {
          ygopro.stoc_send_chat(client, "您当前的房间名是 " + room.name, ygopro.constants.COLORS.BABYBLUE);
        }
    }
    if (!(room && room.random_type)) {
      return cancel;
    }
    oldmsg = msg;
    if (_.any(settings.ban.badword_level3, function(badword) {
      var regexp;
      regexp = new RegExp(badword, 'i');
      return msg.match(regexp);
    }, msg)) {
      log.warn("BAD WORD LEVEL 3", client.name, client.remoteAddress, oldmsg);
      ygopro.stoc_send_chat(client, "您的发言存在不适当的内容，禁止您使用随机对战功能！", ygopro.constants.COLORS.RED);
      ROOM_ban_player(client.name, client.ip, "发言违规");
      ROOM_ban_player(client.name, client.ip, "发言违规", 3);
      client.end();
      cancel = true;
    } else if (_.any(settings.ban.badword_level2, function(badword) {
      var regexp;
      regexp = new RegExp(badword, 'i');
      return msg.match(regexp);
    }, msg)) {
      log.warn("BAD WORD LEVEL 2", client.name, client.remoteAddress, oldmsg);
      ygopro.stoc_send_chat(client, "您的发言存在不适当的内容，发送失败，并记录一次违规！", ygopro.constants.COLORS.RED);
      ROOM_ban_player(client.name, client.ip, "发言违规");
      cancel = true;
    } else {
      _.each(settings.ban.badword_level1, function(badword) {
        var regexp;
        regexp = new RegExp(badword, "ig");
        msg = msg.replace(regexp, "**");
      }, msg);
      if (oldmsg !== msg) {
        log.warn("BAD WORD LEVEL 1", client.name, client.remoteAddress, oldmsg);
        ygopro.stoc_send_chat(client, "请使用文明用语");
        struct = ygopro.structs["chat"];
        struct._setBuff(buffer);
        struct.set("msg", msg);
        buffer = struct.buffer;
      } else if (_.any(settings.ban.badword_level0, function(badword) {
        var regexp;
        regexp = new RegExp(badword, 'i');
        return msg.match(regexp);
      }, msg)) {
        log.info("BAD WORD LEVEL 0", client.name, client.remoteAddress, oldmsg);
      }
    }
    return cancel;
  });

  ygopro.ctos_follow('UPDATE_DECK', true, function(buffer, info, client, server) {
    var buff_main, buff_side, card, current_deck, deck, deck_array, deck_main, deck_side, deck_text, deckbuf, decks, found_deck, i, k, l, len, len1, line, room, struct;
    room = ROOM_all[client.rid];
    if (!room) {
      return false;
    }
    buff_main = (function() {
      var k, ref, results;
      results = [];
      for (i = k = 0, ref = info.mainc; 0 <= ref ? k < ref : k > ref; i = 0 <= ref ? ++k : --k) {
        results.push(info.deckbuf[i]);
      }
      return results;
    })();
    buff_side = (function() {
      var k, ref, ref1, results;
      results = [];
      for (i = k = ref = info.mainc, ref1 = info.mainc + info.sidec; ref <= ref1 ? k < ref1 : k > ref1; i = ref <= ref1 ? ++k : --k) {
        results.push(info.deckbuf[i]);
      }
      return results;
    })();
    if (room.random_type) {
      if (client.is_host) {
        room.waiting_for_player = room.waiting_for_player2;
      }
      room.last_active_time = moment();
    } else if (!room.started && room.hostinfo.mode === 1 && settings.modules.tournament_mode.enabled) {
      struct = ygopro.structs["deck"];
      struct._setBuff(buffer);
      struct.set("mainc", 1);
      struct.set("sidec", 1);
      struct.set("deckbuf", [4392470, 4392470]);
      buffer = struct.buffer;
      found_deck = false;
      decks = fs.readdirSync(settings.modules.tournament_mode.deck_path);
      for (k = 0, len = decks.length; k < len; k++) {
        deck = decks[k];
        if (_.endsWith(deck, client.name + ".ydk")) {
          found_deck = deck;
        }
        if (_.endsWith(deck, client.name + ".ydk.ydk")) {
          found_deck = deck;
        }
      }
      if (found_deck) {
        deck_text = fs.readFileSync(settings.modules.tournament_mode.deck_path + found_deck, {
          encoding: "ASCII"
        });
        deck_array = deck_text.split("\n");
        deck_main = [];
        deck_side = [];
        current_deck = deck_main;
        for (l = 0, len1 = deck_array.length; l < len1; l++) {
          line = deck_array[l];
          if (line.indexOf("!side") >= 0) {
            current_deck = deck_side;
          }
          card = parseInt(line);
          if (!isNaN(card)) {
            current_deck.push(card);
          }
        }
        if (_.isEqual(buff_main, deck_main) && _.isEqual(buff_side, deck_side)) {
          deckbuf = deck_main.concat(deck_side);
          struct.set("mainc", deck_main.length);
          struct.set("sidec", deck_side.length);
          struct.set("deckbuf", deckbuf);
          buffer = struct.buffer;
          ygopro.stoc_send_chat(client, "成功使用卡组 " + found_deck + " 参加比赛。", ygopro.constants.COLORS.BABYBLUE);
        } else {
          ygopro.stoc_send_chat(client, "您的卡组与报名卡组 " + found_deck + " 不符。注意卡组不能有包括卡片顺序在内的任何修改。", ygopro.constants.COLORS.RED);
        }
      } else {
        ygopro.stoc_send_chat(client, client.name + "，没有找到您的报名信息，请确定您使用昵称与报名ID一致。", ygopro.constants.COLORS.RED);
      }
    }
    return false;
  });

  ygopro.ctos_follow('RESPONSE', false, function(buffer, info, client, server) {
    var room;
    room = ROOM_all[client.rid];
    if (!(room && room.random_type)) {
      return;
    }
    room.last_active_time = moment();
  });

  ygopro.ctos_follow('HAND_RESULT', false, function(buffer, info, client, server) {
    var room;
    room = ROOM_all[client.rid];
    if (!(room && room.random_type)) {
      return;
    }
    if (client.is_host) {
      room.waiting_for_player = room.waiting_for_player2;
    }
    room.last_active_time = moment().subtract(settings.modules.hang_timeout - 19, 's');
  });

  ygopro.ctos_follow('TP_RESULT', false, function(buffer, info, client, server) {
    var room;
    room = ROOM_all[client.rid];
    if (!(room && room.random_type)) {
      return;
    }
    room.last_active_time = moment();
  });

  ygopro.stoc_follow('SELECT_HAND', false, function(buffer, info, client, server) {
    var room;
    room = ROOM_all[client.rid];
    if (!(room && room.random_type)) {
      return;
    }
    if (client.is_host) {
      room.waiting_for_player = client;
    } else {
      room.waiting_for_player2 = client;
    }
    room.last_active_time = moment().subtract(settings.modules.hang_timeout - 19, 's');
  });

  ygopro.stoc_follow('SELECT_TP', false, function(buffer, info, client, server) {
    var room;
    room = ROOM_all[client.rid];
    if (!(room && room.random_type)) {
      return;
    }
    room.waiting_for_player = client;
    room.last_active_time = moment();
  });

  ygopro.stoc_follow('CHANGE_SIDE', false, function(buffer, info, client, server) {
    var room;
    room = ROOM_all[client.rid];
    if (!(room && room.random_type)) {
      return;
    }
    if (client.is_host) {
      room.waiting_for_player = client;
    } else {
      room.waiting_for_player2 = client;
    }
    room.last_active_time = moment();
  });

  ygopro.stoc_follow('REPLAY', true, function(buffer, info, client, server) {
    var player, room;
    room = ROOM_all[client.rid];
    if (!room) {
      return settings.modules.tournament_mode.enabled;
    }
    if (settings.modules.enable_cloud_replay && room.random_type) {
      Cloud_replay_ids.push(room.cloud_replay_id);
    }
    if (settings.modules.tournament_mode.enabled) {
      if (client.is_host) {
        log = {
          time: moment().format('YYYY-MM-DD HH:mm:ss'),
          name: room.name,
          roomid: room.port.toString(),
          cloud_replay_id: "R#" + room.cloud_replay_id,
          players: (function() {
            var k, len, ref, results;
            ref = room.players;
            results = [];
            for (k = 0, len = ref.length; k < len; k++) {
              player = ref[k];
              results.push({
                name: player.name,
                winner: player.pos === room.winner
              });
            }
            return results;
          })()
        };
        settings.modules.tournament_mode.duel_log.push(log);
        nconf.myset(settings, "modules:tournament_mode:duel_log", settings.modules.tournament_mode.duel_log);
      }
      if (settings.modules.enable_cloud_replay) {
        ygopro.stoc_send_chat(client, "本场比赛云录像：R#" + room.cloud_replay_id + "。将于本局结束后可播放。", ygopro.constants.COLORS.BABYBLUE);
      }
      return true;
    } else {
      return false;
    }
  });

  setInterval(function() {
    var k, len, room, time_passed;
    for (k = 0, len = ROOM_all.length; k < len; k++) {
      room = ROOM_all[k];
      if (!(room && room.started && room.random_type && room.last_active_time && room.waiting_for_player)) {
        continue;
      }
      time_passed = Math.floor((moment() - room.last_active_time) / 1000);
      if (time_passed >= settings.modules.hang_timeout) {
        room.last_active_time = moment();
        ROOM_ban_player(room.waiting_for_player.name, room.waiting_for_player.ip, "挂机");
        ygopro.stoc_send_chat_to_room(room, room.waiting_for_player.name + " 被系统请出了房间", ygopro.constants.COLORS.RED);
        room.waiting_for_player.server.end();
      } else if (time_passed >= (settings.modules.hang_timeout - 20) && !(time_passed % 10)) {
        ygopro.stoc_send_chat_to_room(room, room.waiting_for_player.name + " 已经很久没有操作了，若继续挂机，将于" + (settings.modules.hang_timeout - time_passed) + "秒后被请出房间", ygopro.constants.COLORS.RED);
      }
    }
  }, 1000);

  if (settings.modules.http) {
    requestListener = function(request, response) {
      var duellog, k, len, parseQueryString, pass_validated, player, room, roomsjson, u;
      parseQueryString = true;
      u = url.parse(request.url, parseQueryString);
      pass_validated = u.query.pass === settings.modules.http.password;
      if (u.pathname === '/api/getrooms') {
        if (!pass_validated) {
          response.writeHead(200);
          response.end(u.query.callback + '( {"rooms":[{"roomid":"0","roomname":"密码错误","needpass":"true"}]} );');
        } else {
          response.writeHead(200);
          roomsjson = JSON.stringify({
            rooms: (function() {
              var k, len, results;
              results = [];
              for (k = 0, len = ROOM_all.length; k < len; k++) {
                room = ROOM_all[k];
                if (room && room.established) {
                  results.push({
                    pid: room.process.pid.toString(),
                    roomid: room.port.toString(),
                    roomname: pass_validated ? room.name : room.name.split('$', 2)[0],
                    needpass: (room.name.indexOf('$') !== -1).toString(),
                    users: (function() {
                      var l, len1, ref, results1;
                      ref = room.players;
                      results1 = [];
                      for (l = 0, len1 = ref.length; l < len1; l++) {
                        player = ref[l];
                        if (player.pos != null) {
                          results1.push({
                            id: (-1).toString(),
                            name: player.name,
                            pos: player.pos
                          });
                        }
                      }
                      return results1;
                    })(),
                    istart: room.started ? 'start' : 'wait'
                  });
                }
              }
              return results;
            })()
          });
          response.end(u.query.callback + "( " + roomsjson + " );");
        }
      } else if (u.pathname === '/api/duellog' && settings.modules.tournament_mode.enabled) {
        if (!pass_validated) {
          response.writeHead(200);
          response.end("密码错误");
          return;
        } else {
          response.writeHead(200);
          duellog = JSON.stringify(settings.modules.tournament_mode.duel_log);
          response.end(u.query.callback + "( " + duellog + " );");
        }
      } else if (u.pathname === '/api/message') {
        if (!pass_validated) {
          response.writeHead(200);
          response.end(u.query.callback + "( ['密码错误', 0] );");
          return;
        }
        if (u.query.shout) {
          for (k = 0, len = ROOM_all.length; k < len; k++) {
            room = ROOM_all[k];
            if (room && room.established) {
              ygopro.stoc_send_chat_to_room(room, u.query.shout, ygopro.constants.COLORS.YELLOW);
            }
          }
          response.writeHead(200);
          response.end(u.query.callback + "( ['shout ok', '" + u.query.shout + "'] );");
        } else if (u.query.stop) {
          if (u.query.stop === 'false') {
            u.query.stop = false;
          }
          settings.modules.stop = u.query.stop;
          response.writeHead(200);
          response.end(u.query.callback + "( ['stop ok', '" + u.query.stop + "'] );");
        } else if (u.query.welcome) {
          nconf.myset(settings, 'modules:welcome', u.query.welcome);
          response.writeHead(200);
          response.end(u.query.callback + "( ['welcome ok', '" + u.query.welcome + "'] );");
        } else if (u.query.getwelcome) {
          response.writeHead(200);
          response.end(u.query.callback + "( ['get ok', '" + settings.modules.welcome + "'] );");
        } else if (u.query.loadtips) {
          load_tips();
          response.writeHead(200);
          response.end(u.query.callback + "( ['loading tip', '" + settings.modules.tips + "'] );");
        } else if (u.query.loaddialogues) {
          load_dialogues();
          response.writeHead(200);
          response.end(u.query.callback + "( ['loading dialogues', '" + settings.modules.dialogues + "'] );");
        } else if (u.query.ban) {
          ban_user(u.query.ban);
          response.writeHead(200);
          response.end(u.query.callback + "( ['ban ok', '" + u.query.ban + "'] );");
        } else {
          response.writeHead(404);
          response.end();
        }
      } else {
        response.writeHead(404);
        response.end();
      }
    };
    http_server = http.createServer(requestListener);
    http_server.listen(settings.modules.http.port);
    if (settings.modules.http.ssl.enabled) {
      https = require('https');
      options = {
        cert: fs.readFileSync(settings.modules.http.ssl.cert),
        key: fs.readFileSync(settings.modules.http.ssl.key)
      };
      https_server = https.createServer(options, requestListener);
      roomlist.init(https_server, Room);
      https_server.listen(settings.modules.http.ssl.port);
    }
  }

}).call(this);
