// Generated by CoffeeScript 2.5.1
(function() {
  var Struct, _, declaration, field, i, len, loadJSON, name, result, structs_declaration, type, typedefs;

  _ = require('underscore');

  _.str = require('underscore.string');

  _.mixin(_.str.exports());

  Struct = require('./struct.js').Struct;

  loadJSON = require('load-json-file').sync;

  this.i18ns = loadJSON('./data/i18n.json');

  //常量/类型声明
  structs_declaration = loadJSON('./data/structs.json'); //结构体声明

  typedefs = loadJSON('./data/typedefs.json'); //类型声明

  this.proto_structs = loadJSON('./data/proto_structs.json'); //消息与结构体的对应，未完成，对着duelclient.cpp加

  this.constants = loadJSON('./data/constants.json'); //network.h里定义的常量

  
  //结构体定义
  this.structs = {};

  for (name in structs_declaration) {
    declaration = structs_declaration[name];
    result = Struct();
    for (i = 0, len = declaration.length; i < len; i++) {
      field = declaration[i];
      if (field.encoding) {
        switch (field.encoding) {
          case "UTF-16LE":
            result.chars(field.name, field.length * 2, field.encoding);
            break;
          default:
            throw `unsupported encoding: ${field.encoding}`;
        }
      } else {
        type = field.type;
        if (typedefs[type]) {
          type = typedefs[type];
        }
        if (field.length) {
          result.array(field.name, field.length, type); //不支持结构体
        } else {
          if (this.structs[type]) {
            result.struct(field.name, this.structs[type]);
          } else {
            result[type](field.name);
          }
        }
      }
    }
    this.structs[name] = result;
  }

  //消息跟踪函数 需要重构, 另暂时只支持异步, 同步没做.
  this.stoc_follows = {};

  this.stoc_follows_before = {};

  this.stoc_follows_after = {};

  this.ctos_follows = {};

  this.ctos_follows_before = {};

  this.ctos_follows_after = {};

  this.replace_proto = function(proto, tp) {
    var changed_proto, key, ref, value;
    if (typeof proto !== "string") {
      return proto;
    }
    changed_proto = proto;
    ref = this.constants[tp];
    for (key in ref) {
      value = ref[key];
      if (value === proto) {
        changed_proto = key;
        break;
      }
    }
    if (!this.constants[tp][changed_proto]) {
      throw "unknown proto";
    }
    return changed_proto;
  };

  this.stoc_follow = function(proto, synchronous, callback) {
    var changed_proto;
    changed_proto = this.replace_proto(proto, "STOC");
    this.stoc_follows[changed_proto] = {
      callback: callback,
      synchronous: synchronous
    };
  };

  this.stoc_follow_before = function(proto, synchronous, callback) {
    var changed_proto;
    changed_proto = this.replace_proto(proto, "STOC");
    if (!this.stoc_follows_before[changed_proto]) {
      this.stoc_follows_before[changed_proto] = [];
    }
    this.stoc_follows_before[changed_proto].push({
      callback: callback,
      synchronous: synchronous
    });
  };

  this.stoc_follow_after = function(proto, synchronous, callback) {
    var changed_proto;
    changed_proto = this.replace_proto(proto, "STOC");
    if (!this.stoc_follows_after[changed_proto]) {
      this.stoc_follows_after[changed_proto] = [];
    }
    this.stoc_follows_after[changed_proto].push({
      callback: callback,
      synchronous: synchronous
    });
  };

  this.ctos_follow = function(proto, synchronous, callback) {
    var changed_proto;
    changed_proto = this.replace_proto(proto, "CTOS");
    this.ctos_follows[changed_proto] = {
      callback: callback,
      synchronous: synchronous
    };
  };

  this.ctos_follow_before = function(proto, synchronous, callback) {
    var changed_proto;
    changed_proto = this.replace_proto(proto, "CTOS");
    if (!this.ctos_follows_before[changed_proto]) {
      this.ctos_follows_before[changed_proto] = [];
    }
    this.ctos_follows_before[changed_proto].push({
      callback: callback,
      synchronous: synchronous
    });
  };

  this.ctos_follow_after = function(proto, synchronous, callback) {
    var changed_proto;
    changed_proto = this.replace_proto(proto, "CTOS");
    if (!this.ctos_follows_after[changed_proto]) {
      this.ctos_follows_after[changed_proto] = [];
    }
    this.ctos_follows_after[changed_proto].push({
      callback: callback,
      synchronous: synchronous
    });
  };

  //消息发送函数,至少要把俩合起来....
  this.stoc_send = function(socket, proto, info) {
    var buffer, header, key, ref, struct, value;
    if (socket.closed) {
      return;
    }
    //console.log proto, proto_structs.STOC[proto], structs[proto_structs.STOC[proto]]
    if (typeof info === 'undefined') {
      buffer = "";
    } else if (Buffer.isBuffer(info)) {
      buffer = info;
    } else {
      struct = this.structs[this.proto_structs.STOC[proto]];
      struct.allocate();
      struct.set(info);
      buffer = struct.buffer();
    }
    if (typeof proto === 'string') { //需要重构
      ref = this.constants.STOC;
      for (key in ref) {
        value = ref[key];
        if (value === proto) {
          proto = key;
          break;
        }
      }
      if (!this.constants.STOC[proto]) {
        throw "unknown proto";
      }
    }
    header = Buffer.allocUnsafe(3);
    header.writeUInt16LE(buffer.length + 1, 0);
    header.writeUInt8(proto, 2);
    socket.write(header);
    if (buffer.length) {
      socket.write(buffer);
    }
  };

  this.ctos_send = function(socket, proto, info) {
    var buffer, header, key, ref, struct, value;
    if (socket.closed) {
      return;
    }
    //console.log proto, proto_structs.CTOS[proto], structs[proto_structs.CTOS[proto]]
    if (typeof info === 'undefined') {
      buffer = "";
    } else if (Buffer.isBuffer(info)) {
      buffer = info;
    } else {
      struct = this.structs[this.proto_structs.CTOS[proto]];
      struct.allocate();
      struct.set(info);
      buffer = struct.buffer();
    }
    if (typeof proto === 'string') { //需要重构
      ref = this.constants.CTOS;
      for (key in ref) {
        value = ref[key];
        if (value === proto) {
          proto = key;
          break;
        }
      }
      if (!this.constants.CTOS[proto]) {
        throw "unknown proto";
      }
    }
    header = Buffer.allocUnsafe(3);
    header.writeUInt16LE(buffer.length + 1, 0);
    header.writeUInt8(proto, 2);
    socket.write(header);
    if (buffer.length) {
      socket.write(buffer);
    }
  };

  //util
  this.stoc_send_chat = function(client, msg, player = 8) {
    var j, len1, line, o, r, re, ref, ref1;
    if (!client) {
      console.log("err stoc_send_chat");
      return;
    }
    ref = _.lines(msg);
    for (j = 0, len1 = ref.length; j < len1; j++) {
      line = ref[j];
      if (player >= 10) {
        line = "[Server]: " + line;
      }
      ref1 = this.i18ns[client.lang];
      for (o in ref1) {
        r = ref1[o];
        re = new RegExp("\\$\\{" + o + "\\}", 'g');
        line = line.replace(re, r);
      }
      this.stoc_send(client, 'CHAT', {
        player: player,
        msg: line
      });
    }
  };

  this.stoc_send_chat_to_room = function(room, msg, player = 8) {
    var client, j, k, len1, len2, ref, ref1;
    if (!room) {
      console.log("err stoc_send_chat_to_room");
      return;
    }
    ref = room.players;
    for (j = 0, len1 = ref.length; j < len1; j++) {
      client = ref[j];
      if (client) {
        this.stoc_send_chat(client, msg, player);
      }
    }
    ref1 = room.watchers;
    for (k = 0, len2 = ref1.length; k < len2; k++) {
      client = ref1[k];
      if (client) {
        this.stoc_send_chat(client, msg, player);
      }
    }
  };

  this.stoc_send_hint_card_to_room = function(room, card) {
    var client, j, k, len1, len2, ref, ref1;
    if (!room) {
      console.log("err stoc_send_hint_card_to_room");
      return;
    }
    ref = room.players;
    for (j = 0, len1 = ref.length; j < len1; j++) {
      client = ref[j];
      if (client) {
        this.stoc_send(client, 'GAME_MSG', {
          curmsg: 2,
          type: 10,
          player: 0,
          data: card
        });
      }
    }
    ref1 = room.watchers;
    for (k = 0, len2 = ref1.length; k < len2; k++) {
      client = ref1[k];
      if (client) {
        this.stoc_send(client, 'GAME_MSG', {
          curmsg: 2,
          type: 10,
          player: 0,
          data: card
        });
      }
    }
  };

  this.stoc_die = function(client, msg) {
    this.stoc_send_chat(client, msg, this.constants.COLORS.RED);
    if (client) {
      this.stoc_send(client, 'ERROR_MSG', {
        msg: 1,
        code: 9
      });
    }
    if (client) {
      client.system_kicked = true;
      client.destroy();
    }
  };

}).call(this);
