// Generated by CoffeeScript 2.7.0
(function() {
  /*
  Main script of new dashboard account system.
  The account list file is stored at `./config/admin_user.json`. The users are stored at `users`.
  The key is the username. The `permissions` field could be a string, using a permission set from the example, or an object, to define a specific set of permissions.
  eg. An account for a judge could be as follows, to use the default permission of judges,
      "username": {
        "password": "123456",
        "enabled": true,
        "permissions": "judge"
      },
  or as follows, to use a specific set of permissions.
      "username": {
        "password": "123456",
        "enabled": true,
        "permissions": {
          "get_rooms": true,
          "duel_log": true,
          "download_replay": true,
          "deck_dashboard_read": true,
          "deck_dashboard_write": true,
          "shout": true,
          "kick_user": true,
          "start_death": true
        }
      },
  */
  var add_log, bunyan, check_permission, default_data, fs, loadJSON, loadJSONPromise, log, moment, reload, save, setting_save, users, util;

  fs = require('fs');

  loadJSON = require('load-json-file').sync;

  loadJSONPromise = require('load-json-file');

  moment = require('moment');

  moment.updateLocale('zh-cn', {
    relativeTime: {
      future: '%s内',
      past: '%s前',
      s: '%d秒',
      m: '1分钟',
      mm: '%d分钟',
      h: '1小时',
      hh: '%d小时',
      d: '1天',
      dd: '%d天',
      M: '1个月',
      MM: '%d个月',
      y: '1年',
      yy: '%d年'
    }
  });

  bunyan = require('bunyan');

  log = bunyan.createLogger({
    name: "auth"
  });

  util = require('util');

  if (!fs.existsSync('./logs')) {
    fs.mkdirSync('./logs');
  }

  add_log = async function(message) {
    var mt, res, text;
    mt = moment();
    log.info(message);
    text = mt.format('YYYY-MM-DD HH:mm:ss') + " --> " + message + "\n";
    res = false;
    try {
      await fs.promises.appendFile("./logs/" + mt.format('YYYY-MM-DD') + ".log", text);
      res = true;
    } catch (error) {
      res = false;
    }
    return res;
  };

  default_data = loadJSON('./data/default_data.json');

  setting_save = async function(settings) {
    var e;
    try {
      await fs.promises.writeFile(settings.file, JSON.stringify(settings, null, 2));
    } catch (error) {
      e = error;
      add_log("save fail");
    }
  };

  default_data = loadJSON('./data/default_data.json');

  try {
    users = loadJSON('./config/admin_user.json');
  } catch (error) {
    users = default_data.users;
    setting_save(users);
  }

  save = async function() {
    return (await setting_save(users));
  };

  reload = async function() {
    var user_backup;
    user_backup = users;
    try {
      users = (await loadJSONPromise('./config/admin_user.json'));
    } catch (error) {
      users = user_backup;
      await add_log("Invalid user data JSON");
    }
  };

  check_permission = async function(user, permission_required) {
    var _permission, permission;
    _permission = user.permissions;
    permission = _permission;
    if (typeof permission !== 'object') {
      permission = users.permission_examples[_permission];
    }
    if (!permission) {
      await add_log("Permision not set:" + _permission);
      return false;
    }
    return permission[permission_required];
  };

  this.auth = async function(name, pass, permission_required, action = 'unknown', no_log) {
    var user;
    await reload();
    user = users.users[name];
    if (!user) {
      await add_log("Unknown user login. User: " + name + ", Permission needed: " + permission_required + ", Action: " + action);
      return false;
    }
    if (user.password !== pass) {
      await add_log("Unauthorized user login. User: " + name + ", Permission needed: " + permission_required + ", Action: " + action);
      return false;
    }
    if (!user.enabled) {
      await add_log("Disabled user login. User: " + name + ", Permission needed: " + permission_required + ", Action: " + action);
      return false;
    }
    if (!(await check_permission(user, permission_required))) {
      await add_log("Permission denied. User: " + name + ", Permission needed: " + permission_required + ", Action: " + action);
      return false;
    }
    if (!no_log) {
      await add_log("Operation success. User: " + name + ", Permission needed: " + permission_required + ", Action: " + action);
    }
    return true;
  };

  this.add_user = async function(name, pass, enabled, permissions) {
    await reload();
    if (users.users[name]) {
      return false;
    }
    users.users[name] = {
      "password": pass,
      "enabled": enabled,
      "permissions": permissions
    };
    await save();
    return true;
  };

  this.delete_user = async function(name) {
    await reload();
    if (!users.users[name]) {
      return false;
    }
    delete users.users[name];
    await save();
  };

  this.update_user = async function(name, key, value) {
    await reload();
    if (!users.users[name]) {
      return false;
    }
    users.users[name][key] = value;
    await save();
  };

}).call(this);
