// Generated by CoffeeScript 1.6.3
(function() {
  var Inotify, Struct, constants, ctos_follow, ctos_follows, ctos_send, declaration, field, freeport, fs, http, inotify, listener, name, net, path, proto_structs, result, rooms, rooms_port_process, server_listener, settings, spawn, stoc_follow, stoc_follows, stoc_send, structs, structs_declaration, taici, type, typedefs, url, _, _i, _len;

  net = require('net');

  http = require('http');

  url = require('url');

  spawn = require('child_process').spawn;

  freeport = require('freeport');

  Struct = require('struct').Struct;

  _ = require('underscore');

  structs_declaration = require('./structs.json');

  typedefs = require('./typedefs.json');

  proto_structs = require('./proto_structs.json');

  constants = require('./constants.json');

  settings = require('./config.json');

  if (process.argv[2] === '--debug') {
    settings.port++;
    settings.http_port++;
  }

  structs = {};

  for (name in structs_declaration) {
    declaration = structs_declaration[name];
    result = Struct();
    for (_i = 0, _len = declaration.length; _i < _len; _i++) {
      field = declaration[_i];
      if (field.encoding) {
        switch (field.encoding) {
          case "UTF-16LE":
            result.chars(field.name, field.length * 2, field.encoding);
            break;
          default:
            throw "unsupported encoding: " + file.encoding;
        }
      } else {
        type = field.type;
        if (typedefs[type]) {
          type = typedefs[type];
        }
        if (field.length) {
          result.array(field.name, field.length, type);
        } else {
          if (structs[type]) {
            result.struct(field.name, structs[type]);
          } else {
            result[type](field.name);
          }
        }
      }
    }
    structs[name] = result;
  }

  stoc_follows = {};

  ctos_follows = {};

  stoc_follow = function(proto, synchronous, callback) {
    var key, value, _ref;
    if (typeof proto === 'string') {
      _ref = constants.STOC;
      for (key in _ref) {
        value = _ref[key];
        if (value === proto) {
          proto = key;
          break;
        }
      }
      if (!constants.STOC[proto]) {
        throw "unknown proto";
      }
    }
    return stoc_follows[proto] = {
      callback: callback,
      synchronous: synchronous
    };
  };

  ctos_follow = function(proto, synchronous, callback) {
    var key, value, _ref;
    if (typeof proto === 'string') {
      _ref = constants.CTOS;
      for (key in _ref) {
        value = _ref[key];
        if (value === proto) {
          proto = key;
          break;
        }
      }
      if (!constants.CTOS[proto]) {
        throw "unknown proto";
      }
    }
    return ctos_follows[proto] = {
      callback: callback,
      synchronous: synchronous
    };
  };

  stoc_send = function(socket, proto, info) {
    var buffer, header, key, struct, value, _ref;
    if (typeof info === 'undefined') {
      buffer = "";
    } else if (Buffer.isBuffer(info)) {
      buffer = info;
    } else {
      struct = structs[proto_structs.STOC[proto]];
      struct.allocate();
      struct.set(info);
      buffer = struct.buffer();
    }
    if (typeof proto === 'string') {
      _ref = constants.STOC;
      for (key in _ref) {
        value = _ref[key];
        if (value === proto) {
          proto = key;
          break;
        }
      }
      if (!constants.STOC[proto]) {
        throw "unknown proto";
      }
    }
    header = new Buffer(3);
    header.writeUInt16LE(buffer.length + 1, 0);
    header.writeUInt8(proto, 2);
    socket.write(header);
    if (buffer.length) {
      socket.write(buffer);
    }
    return console.log('stoc_sent:', buffer);
  };

  ctos_send = function(socket, proto, info) {
    var buffer, header, key, struct, value, _ref;
    if (typeof info === 'undefined') {
      buffer = "";
    } else if (Buffer.isBuffer(info)) {
      buffer = info;
    } else {
      struct = structs[proto_structs.CTOS[proto]];
      struct.allocate();
      struct.set(info);
      buffer = struct.buffer();
    }
    if (typeof proto === 'string') {
      _ref = constants.CTOS;
      for (key in _ref) {
        value = _ref[key];
        if (value === proto) {
          proto = key;
          break;
        }
      }
      if (!constants.CTOS[proto]) {
        throw "unknown proto";
      }
    }
    header = new Buffer(3);
    header.writeUInt16LE(buffer.length + 1, 0);
    header.writeUInt8(proto, 2);
    socket.write(header);
    if (buffer.length) {
      socket.write(buffer);
    }
    return console.log('ctos_sent:', buffer);
  };

  server_listener = function(port, client, server) {
    var buffer, stoc_buffer, stoc_message_length, stoc_proto, _j, _len1, _ref;
    client.connected = true;
    console.log("connected " + port);
    stoc_buffer = new Buffer(0);
    stoc_message_length = 0;
    stoc_proto = 0;
    _ref = client.pre_connecion_buffers;
    for (_j = 0, _len1 = _ref.length; _j < _len1; _j++) {
      buffer = _ref[_j];
      server.write(buffer);
    }
    server.on("data", function(data) {
      var b, struct;
      console.log('server: ', data);
      stoc_buffer = Buffer.concat([stoc_buffer, data], stoc_buffer.length + data.length);
      while (true) {
        if (stoc_message_length === 0) {
          if (stoc_buffer.length >= 2) {
            stoc_message_length = stoc_buffer.readUInt16LE(0);
          } else {
            break;
          }
        } else if (stoc_proto === 0) {
          if (stoc_buffer.length >= 3) {
            stoc_proto = stoc_buffer.readUInt8(2);
          } else {
            break;
          }
        } else {
          if (stoc_buffer.length >= 2 + stoc_message_length) {
            console.log(constants.STOC[stoc_proto]);
            if (stoc_follows[stoc_proto]) {
              b = stoc_buffer.slice(3, stoc_message_length - 1 + 3);
              if (struct = structs[proto_structs.STOC[constants.STOC[stoc_proto]]]) {
                struct._setBuff(b);
                setTimeout(stoc_follows[stoc_proto].callback, 0, b, struct.fields, client, server);
              } else {
                setTimeout(stoc_follows[stoc_proto].callback, 0, b, null, client, server);
              }
            }
            stoc_buffer = stoc_buffer.slice(2 + stoc_message_length);
            stoc_message_length = 0;
            stoc_proto = 0;
          } else {
            break;
          }
        }
      }
      if (!(stoc_follows[stoc_proto] && stoc_follows[stoc_proto].synchronous)) {
        return client.write(data);
      }
    });
    server.on("error", function(e) {
      console.log("server error " + e);
      return client.end();
    });
    return server.on("close", function(had_error) {
      console.log("server closed " + had_error);
      return client.end();
    });
  };

  rooms = {};

  rooms_port_process = {};

  listener = net.createServer(function(client) {
    var ctos_buffer, ctos_message_length, ctos_proto, server;
    client.connected = false;
    ctos_buffer = new Buffer(0);
    ctos_message_length = 0;
    ctos_proto = 0;
    client.pre_connecion_buffers = new Array();
    server = new net.Socket();
    server.on("error", function(e) {
      return console.log("server error " + e);
    });
    client.on("data", function(data) {
      var b, struct;
      console.log('client: ', data);
      ctos_buffer = Buffer.concat([ctos_buffer, data], ctos_buffer.length + data.length);
      while (true) {
        if (ctos_message_length === 0) {
          if (ctos_buffer.length >= 2) {
            ctos_message_length = ctos_buffer.readUInt16LE(0);
          } else {
            break;
          }
        } else if (ctos_proto === 0) {
          if (ctos_buffer.length >= 3) {
            ctos_proto = ctos_buffer.readUInt8(2);
          } else {
            break;
          }
        } else {
          if (ctos_buffer.length >= 2 + ctos_message_length) {
            console.log(constants.CTOS[ctos_proto]);
            if (ctos_follows[ctos_proto]) {
              b = ctos_buffer.slice(3, ctos_message_length - 1 + 3);
              if (struct = structs[proto_structs.CTOS[constants.CTOS[ctos_proto]]]) {
                struct._setBuff(b);
                setTimeout(ctos_follows[ctos_proto].callback, 0, b, struct.fields, client, server);
              } else {
                setTimeout(ctos_follows[ctos_proto].callback, 0, b, null, client, server);
              }
            }
            ctos_buffer = ctos_buffer.slice(2 + ctos_message_length);
            ctos_message_length = 0;
            ctos_proto = 0;
          } else {
            break;
          }
        }
      }
      if (!(ctos_follows[ctos_proto] && ctos_follows[ctos_proto].synchronous)) {
        if (client.connected) {
          return server.write(data);
        } else {
          return client.pre_connecion_buffers.push(data);
        }
      }
    });
    client.on("error", function(e) {
      console.log("client error " + e);
      return server.end();
    });
    return client.on("close", function(had_error) {
      console.log("client closed " + had_error);
      return server.end();
    });
  }).listen(settings.port, null, null, function() {
    return console.log("server started on " + settings.ip + ":" + settings.port);
  });

  ctos_follow('PLAYER_INFO', true, function(buffer, info, client, server) {
    return client.player = info.name;
  });

  ctos_follow('JOIN_GAME', false, function(buffer, info, client, server) {
    var room_name;
    room_name = info.pass;
    if (info.version !== settings.version) {
      stoc_send(client, 'ERROR_MSG', {
        msg: 4,
        code: settings.version
      });
      return client.end();
    } else if (!room_name.length) {
      stoc_send(client, 'JOIN_GAME', {});
      return stoc_send(client, 'HS_PLAYER_ENTER', {
        name: '提示: 房间为空，请修改房间名',
        pos: 0
      });
    } else if (room_name === '[INCORRECT]') {
      stoc_send(client, 'ERROR_MSG', {
        msg: 1,
        code: 1
      });
      return client.end();
    } else {
      if (client.player !== '[INCORRECT]') {
        if (rooms[room_name]) {
          if (typeof rooms[room_name] === 'number') {
            return server.connect(rooms[room_name], '127.0.0.1', function() {
              return server_listener(rooms[room_name], client, server);
            });
          } else {
            return rooms[room_name].push(client);
          }
        } else {
          return freeport(function(err, port) {
            var param, room;
            if (rooms[room_name]) {
              if (typeof rooms[room_name] === 'number') {
                return server.connect(rooms[room_name], '127.0.0.1', function() {
                  return server_listener(rooms[room_name], client, server);
                });
              } else {
                return rooms[room_name].push(client);
              }
            } else {
              if (err) {
                stoc_send(client, 'ERROR_MSG', {
                  msg: 1,
                  code: 2
                });
                return client.end();
              } else {
                rooms[room_name] = [client];
                if (room_name.slice(0, 2) === 'M#') {
                  param = [0, 0, 1, 'F', 'F', 'F', 8000, 5, 1];
                } else if (room_name.slice(0, 2) === 'T#') {
                  param = [0, 0, 2, 'F', 'F', 'F', 8000, 5, 1];
                } else if ((param = room_name.match(/^(\d)?(\d)(\d)(T|F)(T|F)(T|F)(\d+),(\d+),(\d+)/i))) {
                  param.shift();
                  param[0] === parseInt(param[0]);
                } else {
                  param = [0, 0, 0, 'F', 'F', 'F', 8000, 5, 1];
                }
                param.unshift(port);
                room = spawn('./ygopro', param, {
                  cwd: 'ygocore'
                });
                room.alive = true;
                rooms_port_process[port] = room;
                room.on('exit', function(code) {
                  delete rooms[room_name];
                  return delete rooms_port_process[port];
                });
                return room.stdout.once('data', function(data) {
                  if (rooms[room_name]) {
                    rooms[room_name].forEach(function(c) {
                      return server.connect(port, '127.0.0.1', function() {
                        return server_listener(port, c, server);
                      });
                    });
                    return rooms[room_name] = port;
                  } else {
                    return room.kill();
                  }
                });
              }
            }
          });
        }
      } else {
        stoc_send(client, 'ERROR_MSG', {
          msg: 1,
          code: 2
        });
        return client.end();
      }
    }
  });

  stoc_follow('JOIN_GAME', false, function(buffer, info, client, server) {
    stoc_send(client, 'CHAT', {
      player: 8,
      msg: "Mycard Debugging Server"
    });
    return stoc_send(client, 'CHAT', {
      player: 8,
      msg: "这里是测试中的新服务器, 还不稳定, 随时可能崩溃, 遇到意外请淡定\n                           ˉˉˉˉˉ"
    });
  });

  taici = require('./taici.json');

  stoc_follow('GAME_MSG', false, function(buffer, info, client, server) {
    var card, line, msg, _j, _len1, _ref, _results;
    msg = buffer.readInt8(0);
    if (constants.MSG[msg] === 'SUMMONING' || constants.MSG[msg] === 'SPSUMMONING') {
      card = buffer.readUInt32LE(1);
      if (taici[card]) {
        _ref = taici[card][Math.floor(Math.random() * taici[card].length)].split("\n");
        _results = [];
        for (_j = 0, _len1 = _ref.length; _j < _len1; _j++) {
          line = _ref[_j];
          _results.push(stoc_send(client, 'CHAT', {
            player: 8,
            msg: line
          }));
        }
        return _results;
      }
    }
  });

  http.createServer(function(request, response) {
    if (url.parse(request.url).pathname === '/count.json') {
      response.writeHead(200);
      return response.end(Object.keys(rooms).length.toString());
    } else {
      response.writeHead(404);
      return response.end();
    }
  }).listen(settings.http_port);

  path = require('path');

  fs = require('fs');

  Inotify = require('inotify').Inotify;

  inotify = new Inotify();

  inotify.addWatch({
    path: 'ygocore/replay',
    watch_for: Inotify.IN_CLOSE_WRITE | Inotify.IN_CREATE | Inotify.IN_MODIFY,
    callback: function(event) {
      var mask, port, room;
      mask = event.mask;
      if (event.name) {
        port = parseInt(path.basename(event.name, '.yrp'));
        room = rooms_port_process[port];
        if (room) {
          if (mask & Inotify.IN_CREATE) {

          } else if (mask & Inotify.IN_CLOSE_WRITE) {
            return fs.unlink(path.join('ygocore/replay'), function(err) {});
          } else if (mask & Inotify.IN_MODIFY) {
            return room.alive = true;
          }
        }
      } else {
        return console.log('[warn] event without filename');
      }
    }
  });

  setInterval(function() {
    var port, room, _results;
    _results = [];
    for (port in rooms_port_process) {
      room = rooms_port_process[port];
      if (room.alive) {
        _results.push(room.alive = false);
      } else {
        console.log("killed " + port + " " + room);
        _results.push(room.kill());
      }
    }
    return _results;
  }, 900000);

  /*
  request = require 'request'
  request
    url: 'https://forum.my-card.in/admin/site_contents/faq'
    json: true
    , (error, response, body)->
      console.log body
  
  stoc_follow 'DUEL_START', false, (buffer, info, client, server)->
    stoc_send client, 'CHAT', {
      player: 8
      msg:  "FAQ: 喵喵喵"
    }
  */


  /*
  # 开包大战
  
  packs_weighted_cards = {}
  for pack, cards of require './packs.json'
    packs_weighted_cards[pack] = []
    for card in cards
      for i in [0..card.count]
        packs_weighted_cards[pack].push card.card
  
  console.log packs_weighted_cards
  
  ctos_follow 'UPDATE_DECK', false, (buffer, info, client, server)->
    ctos_send server, 'HS_NOTREADY'
  
    deck = []
    for pack in client.player
      for i in [0...5]
        deck.push packs_weighted_cards[pack][Math.floor(Math.random()*packs_weighted_cards[pack].length)]
  
  
    ctos_send server, 'UPDATE_DECK', {
      mainc: deck.length,
      sidec: 0,
      deckbuf: deck
    }
    ctos_send server, 'HS_READY'
  */


}).call(this);

/*
//@ sourceMappingURL=ygopro-server.map
*/
