import moment from "moment";

interface Client {
    readonly pos: number;
    readonly rid: any;
    [key: string]: any;
}

declare class Handler {
    private readonly handler: (buffer: Buffer, info: any, datas: Buffer[], params: any) => Promise<boolean>;
    public readonly synchronous: boolean;

    constructor(handler: (buffer: Buffer, info: any, datas: Buffer[], params: any) => Promise<boolean>, synchronous: boolean);
    handle(buffer: Buffer, info: any, datas: Buffer[], params: any): Promise<boolean> | boolean;
}

interface HandlerList {
    STOC: Map<number, Handler[]>[];
    CTOS: Map<number, Handler[]>[];
}

interface DirectionAndProto {
    direction: string;
    proto: string;
}

interface Feedback {
    type: string;
    message: string;
}

interface HandleResult {
    datas: Buffer[];
    feedback: Feedback;
}

interface Constants {
    TYPES: Record<string, number>;
    RACES: Record<string, number>;
    ATTRIBUTES: Record<string, number>;
    LINK_MARKERS: Record<string, number>;
    DUEL_STAGE: Record<string, number>;
    COLORS: Record<string, number>;
    TIMING: Record<string, string>;
    NETWORK: Record<string, string>;
    NETPLAYER: Record<string, string>;
    CTOS: Record<string, string>;
    STOC: Record<string, string>;
    PLAYERCHANGE: Record<string, string>;
    ERRMSG: Record<string, string>;
    MODE: Record<string, string>;
    MSG: Record<string, string>;
}

interface YGOProMessagesHelperInstance {
    handlers: HandlerList;
    structs: Map<string, any>;
    structs_declaration: Record<string, any>;
    typedefs: Record<string, string>;
    proto_structs: Record<"CTOS" | "STOC", Record<string, string>>;
    constants: Constants;
    singleHandleLimit: number;

    initDatas(): void;
    initStructs(): void;

    getDirectionAndProto(protoStr: string): DirectionAndProto;
    translateProto(proto: string | number, direction: string): number;

    prepareMessage(protostr: string, info?: string | Buffer | any): Buffer;
    sendMessage(socket: any, protostr: string, info?: string | Buffer | any): void;

    sendMessageAsync(socket: any, protostr: string, info?: string | Buffer | any): Promise<Error>;

    addHandler(
        protostr: string,
        handler: (buffer: Buffer, info: any, datas: Buffer[], params: any) => Promise<boolean>,
        synchronous: boolean,
        priority: number,
    ): void;

    handleBuffer(messageBuffer: Buffer, direction: string, protoFilter?: string[], params?: any): Promise<HandleResult>;
}

interface Room {
    duel_stage: number;
    name: string;
    hostinfo: {
        rule: number;
        mode: number;
        duel_rule: number;
        no_check_deck: boolean;
        no_shuffle_deck: boolean;
        start_lp: number;
        start_hand: number;
        draw_count: number;
        lflist: number;
        time_limit: number;
    };
    winner_name: string;
    scores: { [userName: string]: number };
    winnerNames?: string[];
    dueling_players: Array<{
        ip: string;
        name: string;
        lang: string;
        pass: string;
        join_time: moment.Moment;
        pos: number;
        main: number[];
        side: number[];
    }>;

    replays: Array<Buffer>;

    arena?: "athletic" | "entertain";
    random_type?: string;
    windbot?: boolean;
}

type Dictionary<T> = { [key: string]: T };
type ReloadI18NResult = { regex: RegExp; text: string };
type FollowHandler = (buffer: Buffer, info: Dictionary<any>, client: Client, server: any, data: Dictionary<any>) => Promise<boolean>;

interface YGOPro {
    i18ns: Dictionary<Dictionary<string>>;
    i18nR: Dictionary<Dictionary<string>>;

    reloadI18nR(): Array<ReloadI18NResult>;

    helper: YGOProMessagesHelperInstance;
    structs: YGOProMessagesHelperInstance["structs"];
    structs_declaration: YGOProMessagesHelperInstance["structs_declaration"];
    typedefs: YGOProMessagesHelperInstance["typedefs"];
    proto_structs: YGOProMessagesHelperInstance["proto_structs"];
    constants: YGOProMessagesHelperInstance["constants"];

    stoc_follow(proto: string, synchronous: boolean, callback: FollowHandler): void;
    stoc_follow_before(proto: string, synchronous: boolean, callback: FollowHandler): void;
    stoc_follow_after(proto: string, synchronous: boolean, callback: FollowHandler): void;
    ctos_follow(proto: string, synchronous: boolean, callback: FollowHandler): void;
    ctos_follow_before(proto: string, synchronous: boolean, callback: FollowHandler): void;
    ctos_follow_after(proto: string, synchronous: boolean, callback: FollowHandler): void;

    stoc_send(socket: any, proto: string, info: Dictionary<any>): any;
    ctos_send(socket: any, proto: string, info: Dictionary<any>): any;

    stoc_send_chat(): void;
    stoc_send_chat_to_room(): void;
    stoc_send_hint_card_to_room(): void;

    stoc_die(): void;
}

declare const ygopro: YGOPro;

declare const ROOM_all: Array<Room>;

declare const lflists: Array<Readonly<{ date: moment.Moment; tcg: boolean }>>;

declare const log: { warn(message: string): void; info(message: string): void };
