import moment from "moment";
import { Socket } from "net";
import Bunyan from "bunyan";
import { DuelLog } from "./src/srvpro-entities/DuelLog";
export {} from "./src/export-global";

export interface ToDo {
    [key: string]: any;
}

export interface YGOProSocket extends Socket, ToDo {
    had_new_reconnection: boolean;
}

export interface Client extends YGOProSocket {
    pos: number;
    rid: number;
    abuse_count: number;
    ban_mc: { banned: boolean; until: string; message: string };
    rag: boolean;
    is_post_watcher: boolean;
    retry_count: number;
    name: string;
    pass: string;
    name_vpass: string;
    is_first: boolean;
    lp: number;
    card_count: number;
    is_host: boolean;
    surrend_confirm: boolean;
    kick_count: number;
    deck_saved: boolean;
    main: number[];
    side: number[];
    side_interval: number;
    side_tcount: number;
    selected_preduel: boolean;
    last_game_msg: Buffer;
    last_game_msg_title: string;
    last_hint_msg: Buffer;
    start_deckbuf: Buffer;
    challonge_info: any;
    ready_trap: boolean;
    join_time: string;
    arena_quit_free: boolean;
    replays_sent: boolean;
    victory_words: string;
    server: ServerSocket;
    playLines(lines: string): void;
}

export interface ServerSocket extends YGOProSocket {
    client: Client;
    system_kicked: boolean;
}

export declare class Handler {
    private readonly handler: (buffer: Buffer, info: any, datas: Buffer[], params: any) => Promise<boolean>;
    public readonly synchronous: boolean;

    constructor(handler: (buffer: Buffer, info: any, datas: Buffer[], params: any) => Promise<boolean>, synchronous: boolean);
    handle(buffer: Buffer, info: any, datas: Buffer[], params: any): Promise<boolean> | boolean;
}

export interface HandlerList {
    STOC: Map<number, Handler[]>[];
    CTOS: Map<number, Handler[]>[];
}

export interface DirectionAndProto {
    direction: string;
    proto: string;
}

export interface Feedback {
    type: string;
    message: string;
}

export interface HandleResult {
    datas: Buffer[];
    feedback: Feedback;
}

export interface Constants {
    TYPES: Record<string, number>;
    RACES: Record<string, number>;
    ATTRIBUTES: Record<string, number>;
    LINK_MARKERS: Record<string, number>;
    DUEL_STAGE: Record<string, number>;
    COLORS: Record<string, number>;
    TIMING: Record<string, string>;
    NETWORK: Record<string, string>;
    NETPLAYER: Record<string, string>;
    CTOS: Record<string, string>;
    STOC: Record<string, string>;
    PLAYERCHANGE: Record<string, string>;
    ERRMSG: Record<string, string>;
    MODE: Record<string, string>;
    MSG: Record<string, string>;
}

export interface YGOProMessagesHelperInstance {
    handlers: HandlerList;
    structs: Map<string, any>;
    structs_declaration: Record<string, any>;
    typedefs: Record<string, string>;
    proto_structs: Record<"CTOS" | "STOC", Record<string, string>>;
    constants: Constants;
    singleHandleLimit: number;

    initDatas(): void;
    initStructs(): void;

    getDirectionAndProto(protoStr: string): DirectionAndProto;
    translateProto(proto: string | number, direction: string): number;

    prepareMessage(protostr: string, info?: string | Buffer | any): Buffer;
    sendMessage(socket: any, protostr: string, info?: string | Buffer | any): void;

    sendMessageAsync(socket: any, protostr: string, info?: string | Buffer | any): Promise<Error>;

    addHandler(
        protostr: string,
        handler: (buffer: Buffer, info: any, datas: Buffer[], params: any) => Promise<boolean>,
        synchronous: boolean,
        priority: number,
    ): void;

    handleBuffer(messageBuffer: Buffer, direction: string, protoFilter?: string[], params?: any): Promise<HandleResult>;
}

export interface WindbotData {
    name: string;
    deck: string;
    dialog: string;
}

export interface HostInfo {
    rule: number;
    mode: number;
    duel_rule: number;
    no_check_deck: boolean;
    no_shuffle_deck: boolean;
    start_lp: number;
    start_hand: number;
    draw_count: number;
    lflist: number;
    time_limit: number;
}

export interface Room {
    duel_stage: number;
    name: string;
    hostinfo: HostInfo;
    winner_name: string;
    scores: { [userName: string]: number };
    winnerNames?: string[];

    replays: Array<Buffer>;

    arena?: "athletic" | "entertain";
    random_type?: string;
    windbot?: boolean;

    title: string;
    private: boolean;

    add_windbot(data: WindbotData): void;
    auto_death_triggered: boolean;
    cancel_death(): boolean;
    challonge_info: any;
    check_athletic(): Promise<void>;
    cloud_replay_id: number;
    death: number;
    decks: Record<string, string>;
    deprecated: boolean;
    determine_firstgo: Client;
    disconnect(client: Client, error: string): void;
    disconnector: "server" | undefined;
    duel_count: number;
    dueling_players: Record<number, Client>;
    error: string;
    established: boolean;
    finished: boolean;
    finished_by_death: boolean;
    finish_recover(fail?: boolean);
    first_list: string[];
    get_challonge_score(): { winnerId: number | "tie"; scoresCsv: string };
    get_disconnected_count(): number;
    get_host(): Client;
    get_playing_player(): Client[];
    has_ygopro_error: boolean;
    initialize_recover(): boolean;
    join_game_buffer: Buffer;
    join_player(client: Client): boolean;
    join_post_watch(client: Client): boolean;
    kicked: boolean;
    last_active_time: string;
    long_resolve_card: number;
    long_resolve_chain: boolean[] | undefined;
    match_kill: boolean;
    max_player: number;
    player_datas: { name: string; pos: number; key: string }[];
    players: Client[];
    watchers: Client[];
    playLines(lines: string): void;
    port: number;
    process_pid: number;
    ready_player_count: number;
    ready_player_count_without_host: number;
    recorder: Socket;
    recorder_buffers: Buffer[];
    recover_buffers: Buffer[];
    recover_duel_log: DuelLog;
    recover_duel_log_id: number;
    recovered: boolean;
    recover_from_turn: number;
    recovering: boolean;
    recover_replay: any; // TODO
    refreshLastActiveTime(): void;
    replays_sent_to_watchers: boolean;
    selecting_tp: boolean;
    send_replays(): boolean;
    start_death(): boolean;
    start_time: string;
    terminate(): void;
    turn: number;
    waiting_for_player: Client;
    waiting_for_player2: Client;
    waiting_for_player_interval: number;
    waiting_for_player_time: number;
    watcher: Socket;
    watcher_buffers: Buffer[];
    welcome: string;
    welcome2: string;
    winner: number;
}

export type Dictionary<T> = { [key: string]: T };
export type ReloadI18NResult = { regex: RegExp; text: string };
export type FollowHandler = (buffer: Buffer, info: Dictionary<any>, client: Client, server: ServerSocket, data: Buffer[]) => Promise<boolean>;

export interface YGOPro {
    i18ns: Dictionary<Dictionary<string>>;
    i18nR: Dictionary<Dictionary<string>>;

    reloadI18nR(): Array<ReloadI18NResult>;

    helper: YGOProMessagesHelperInstance;
    structs: YGOProMessagesHelperInstance["structs"];
    structs_declaration: YGOProMessagesHelperInstance["structs_declaration"];
    typedefs: YGOProMessagesHelperInstance["typedefs"];
    proto_structs: YGOProMessagesHelperInstance["proto_structs"];
    constants: YGOProMessagesHelperInstance["constants"];

    stoc_follow(proto: string, synchronous: boolean, callback: FollowHandler): void;
    stoc_follow_before(proto: string, synchronous: boolean, callback: FollowHandler): void;
    stoc_follow_after(proto: string, synchronous: boolean, callback: FollowHandler): void;
    ctos_follow(proto: string, synchronous: boolean, callback: FollowHandler): void;
    ctos_follow_before(proto: string, synchronous: boolean, callback: FollowHandler): void;
    ctos_follow_after(proto: string, synchronous: boolean, callback: FollowHandler): void;

    stoc_send(socket: any, proto: string, info: Dictionary<any>): any;
    ctos_send(socket: any, proto: string, info: Dictionary<any>): any;

    stoc_send_chat(client: Client, message: string, color?: number): void;
    stoc_send_chat_to_room(room: Room, message: string, color?: number): void;
    stoc_send_hint_card_to_room(room: Room, code: number): void;

    stoc_die(client: Client, message: string): void;
}

declare global {
    export const ygopro: YGOPro;

    export const ROOM_all: Array<Room>;

    export const lflists: Array<Readonly<{ date: moment.Moment; tcg: boolean }>>;
    export const log: Bunyan;

    export const import_datas: (keyof Client)[];

    export function setting_save(settings: { file: string }): Promise<void>;

    export function setting_change(settings: { file: string }, path: string, val: any): Promise<void>;
    export const auth: any;
    export const moment_now: moment.Moment;
    export const moment_now_string: string;
    export const moment_long_ago_string: string;
    export const settings: any;
    export const tips: any;
}
