use std::{net::SocketAddr, str::FromStr};
use warp::Filter;

mod infra;
mod service;

// TODO: Configurable
const SERVE_ADDR: &str = "127.0.0.1:3030";

#[tokio::main]
async fn main() -> anyhow::Result<()> {
    pretty_env_logger::try_init()?;

    let workspace = env!("CARGO_MANIFEST_DIR");
    let strings_manager = service::strings_conf_reader(format!(
        "{workspace}/ygopro-database/locales/zh-CN/strings.conf"
    ))?;

    // TODO: use CORS correctly
    let cors = warp::cors()
        .allow_any_origin()
        .allow_credentials(true)
        .allow_header("content-type")
        .allow_method("GET");

    let deck = warp::path!("deck" / String)
        .map(service::deck_service)
        .with(cors.clone());

    // TODO: cards服务暂时仅支持单卡查询
    let cards = warp::path!("cards" / String)
        .map(service::cards_service)
        .with(cors.clone());

    let strings = warp::path!("strings" / String)
        .map(service::strings_service(strings_manager))
        .with(cors.clone());

    // TODO: 模块化
    let images = warp::path("images")
        .and(warp::fs::dir("./images/"))
        .with(cors);

    warp::serve(deck.or(cards).or(images).or(strings))
        .run(SocketAddr::from_str(SERVE_ADDR)?)
        .await;

    Ok(())
}
