use std::ops::{Deref, DerefMut};

use diesel::{Connection, SqliteConnection};

pub enum DbConn {
    // Currently only sqlite Connection
    SqliteConn(SqliteConnection),
}

impl DbConn {
    pub fn establish_sqlite(database_url: &str) -> anyhow::Result<Self> {
        Ok(Self::SqliteConn(SqliteConnection::establish(database_url)?))
    }
}

impl Deref for DbConn {
    type Target = SqliteConnection;

    fn deref(&self) -> &Self::Target {
        match self {
            DbConn::SqliteConn(conn) => conn,
        }
    }
}

impl DerefMut for DbConn {
    fn deref_mut(&mut self) -> &mut Self::Target {
        match self {
            DbConn::SqliteConn(conn) => conn,
        }
    }
}

#[cfg(test)]
mod tests {
    use super::DbConn;

    #[test]
    fn test_establish_sqlite() {
        let workspace = env!("CARGO_MANIFEST_DIR");
        let db_url = format!("{}/ygopro-database/locales/zh-CN/cards.cdb", workspace);
        let _conn = DbConn::establish_sqlite(&db_url).unwrap();
    }
}
