mod db;

// TODO: 这里更合理的做法应该是前端通过`POST`请求
// 数据，二进制格式使用PB协议编码，PB文件定义在`neos-protobuf`项目里面，
// `neos-rs`项目添加`neos-protobuf`项目作为子模块。
//
// 暂时先实现简单的`GET`接口
pub fn service(param: String) -> String {
    let id = param.parse::<i64>().unwrap_or_default();

    match (|| {
        // TODO: 应该在服务冷启动的时候获取`CardsDB`实例，
        // 而不是在每次`HTTP`请求的时候重新获取
        let mut cards_db = db::CardsDB::new()?;
        let datas = cards_db
            .select_card_datas(&[id])?
            .remove(&id)
            .unwrap_or_default();
        let texts = cards_db
            .select_card_texts(&[id])?
            .remove(&id)
            .unwrap_or_default();

        Ok::<(db::CardDatas, db::CardTexts), anyhow::Error>((datas, texts))
    })() {
        Ok((data, text)) => {
            let meta = CardMeta { id, data, text };

            serde_json::to_string(&meta).unwrap_or_default()
        }
        Err(e) => {
            log::error!("Handle cards service error={:?}", e);

            serde_json::to_string(&CardMeta::default()).unwrap_or_default()
        }
    }
}

#[derive(serde::Serialize, Default, Debug)]
pub struct CardMeta {
    pub id: i64,
    pub data: db::CardDatas,
    pub text: db::CardTexts,
}
