set -o errexit

apiRoot=https://sapi.moecube.com:444

source ./src/login.sh
source ./src/prefix.sh

handleErrorMessage() {
  rawJsonInput="$1"
  successInfo=$(echo "$rawJsonInput" | jq '.success')
  
  if [[ "$successInfo" != "true" ]]; then
    echo "$rawJsonInput"
    exit 1
  fi
}

makeBuild() {
  appName="$1"
  appPath="$2"
  if [[ -z "$appPath" ]]; then
    appPath="pool/$appName"
  fi
  echo "Packaging $appName from $appPath"
  if [[ -z "$appVersion" ]]; then
    appVersion="$3"
  fi
  if [[ -z "$appVersion" ]]; then
    if [[ -z "$appVersionPlatform" ]]; then
      appVersionPlatform=win32
    fi
    appVersion=$(curl -sL -H "$header" "$apiRoot/release/api/app?id=$appName" | jq -r ".data[0].appData.version.$appVersionPlatform")
  fi
  echo "Version: $appVersion"
  currentPath="$PWD"
  cd "$appPath"
  tmpfile=$(mktemp ./upload_XXXXXX.tar.zst)
  tar -I 'zstd -T0' -cf "$tmpfile" .
  result=$(curl -L -H "$header" -X POST "$apiRoot/release/api/build/$appName/${appVersion}${suffix}" -F "file=@$tmpfile")
  rm -f "$tmpfile"
  handleErrorMessage "$result"
  echo "$result" | jq .
  cd ..
}

deleteBuild() {
  appName="$1"
  if [[ -z "$appVersion" ]]; then
    appVersion="$2"
  fi
  echo "Removing build $appName"
  echo "Version: $appVersion"
  result=$(curl -sL -H "$header" -X DELETE "$apiRoot/release/api/build/$appName/${appVersion}${suffix}")
  handleErrorMessage "$result"
  echo "$result" | jq .
}

getAppInfoRaw() {
  appName="$1"
  url="$apiRoot/release/api/app?id=$appName"
  if [[ "$2" == 1 ]]; then
    url="$url&simple=1"
  fi
  result=$(curl -sL -H "$header" "$url")
  handleErrorMessage "$result"
  echo "$result"
}

getAppBuilds() {
  getAppInfoRaw "$1" 0 | jq ".data[0].depots"
}

getAppJson() {
  appName="$1"
  getAppInfoRaw "$1" 1 | jq ".data[0].appData" | tee "./jsons/$appName.json"
}

uploadAppJson() {
  appName="$1"
  jsonPath="$2"
  if [[ -z "$jsonPath" ]]; then
    jsonPath="./jsons/$appName.json"
  fi
  echo "Updating $appName with info from $jsonPath."
  result=$(curl -sL -H "$header" -H "Content-Type: application/json" -d "@$jsonPath" -X POST "$apiRoot/release/api/app")
  handleErrorMessage "$result"
  echo "$result" | jq .
}

action() {
  echo "Running action $apiRoot/release/api/$@"
  result=$(curl -sL -H "$header" "$apiRoot/release/api/$@")
  handleErrorMessage "$result"
  echo "$result" | jq .
}

help() {
  cat ./README.md
}
