import {
  Body,
  Controller,
  Headers,
  Post,
  ValidationPipe,
} from '@nestjs/common';
import {
  ApiBody,
  ApiCreatedResponse,
  ApiHeader,
  ApiOperation,
  ApiTags,
} from '@nestjs/swagger';
import { AuthService } from './auth.service';
import { SendCodeDto } from './dto/SendCode.dto';
import {
  BlankReturnMessageDto,
  ReturnMessageDto,
  StringReturnMessageDto,
} from '../dto/ReturnMessage.dto';

@Controller('api/auth')
@ApiTags('Auth')
export class AuthController {
  constructor(private readonly authService: AuthService) {}

  @Post('sendcode')
  @ApiOperation({ summary: '发送 token' })
  @ApiBody({ type: SendCodeDto })
  @ApiCreatedResponse({ type: BlankReturnMessageDto })
  async sendCode(
    @Body(new ValidationPipe({ transform: true })) sendCodeDto: SendCodeDto,
  ): Promise<BlankReturnMessageDto> {
    await this.authService.sendCode(sendCodeDto.userId);
    return new BlankReturnMessageDto(201, 'success');
  }

  @Post('verifycode')
  @ApiOperation({ summary: '验证 token' })
  @ApiHeader({ name: 'Authorization', required: true })
  @ApiCreatedResponse({ type: StringReturnMessageDto })
  async verifyCode(@Headers('Authorization') token: string) {
    const realToken = token?.startsWith('Bearer ') ? token.substring(7) : token;
    const userId = await this.authService.verify(realToken);
    return new ReturnMessageDto(201, 'success', userId);
  }
}
