import yaml from 'yaml';
import * as fs from 'fs';
import { Adapter } from 'koishi';
import S3Assets from '@koishijs/plugin-assets-s3';
import { AdapterConfig } from '../onebot-improved/utils';
import { BotConfig } from '../onebot-improved';
import { JwtModuleOptions } from '@nestjs/jwt';

export interface Config {
  host: string;
  port: number;
  onebot: Adapter.PluginConfig<AdapterConfig, BotConfig>;
  s3?: S3Assets.Config;
  jwt: JwtModuleOptions;
  centerAccount: string;
}

const defaultConfig: Config = {
  host: '::',
  port: 3000,
  onebot: { bots: [] },
  jwt: {
    secretOrPrivateKey: 'secret',
    signOptions: {
      expiresIn: '1d',
    },
  },
  centerAccount: '1111111111',
};

export async function loadConfig(): Promise<Config> {
  let readConfig: Partial<Config> = {};
  try {
    const configText = await fs.promises.readFile('./config.yaml', 'utf-8');
    readConfig = yaml.parse(configText);
  } catch (e) {
    console.error(`Failed to read config: ${e.toString()}`);
  }
  return {
    ...defaultConfig,
    ...readConfig,
  };
}
