import { Injectable } from '@nestjs/common';
import { WireContextService } from 'koishi-nestjs';
import { Bot } from 'koishi';

@Injectable()
export class BotService {
  @WireContextService()
  private bots: Bot[];

  private botMap = new Map<string, Bot>();

  getBot(id: string): Bot {
    if (this.botMap.has(id)) {
      return this.botMap.get(id);
    }
    const bot = this.bots.find((bot) => bot.selfId === id);
    if (!bot) {
      return;
    }
    this.botMap.set(id, bot);
    return bot;
  }
}
