import { Module } from '@nestjs/common';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { loadConfig } from './utility/config';
import { KoishiModule, PluginDef } from 'koishi-nestjs';
import AdapterOnebot, { BotConfig } from './onebot-improved';
import { Adapter } from 'koishi';
import { AdapterConfig } from './onebot-improved/utils';
import { MessageService } from './message/message.service';
import S3Assets from '@koishijs/plugin-assets-s3';
import { JwtModule, JwtModuleOptions } from '@nestjs/jwt';
import { AuthService } from './auth/auth.service';
import { BotService } from './bot/bot.service';
import { CENTER_ACCOUNT_TOKEN } from './utility/constant';
import { ElasticsearchModule } from '@nestjs/elasticsearch';
import { AuthController } from './auth/auth.controller';

@Module({
  imports: [
    ConfigModule.forRoot({
      ignoreEnvVars: true,
      load: [loadConfig],
      isGlobal: true,
    }),
    ElasticsearchModule.register({
      node: 'http://poi.lan:9200',
    }),
    KoishiModule.registerAsync({
      inject: [ConfigService],
      useFactory: (configService: ConfigService) => {
        const onebotConfig = configService.get<
          Adapter.PluginConfig<AdapterConfig, BotConfig>
        >('onebot');
        const s3Config = configService.get<S3Assets.Config>('s3');
        return {
          prefix: '__never_prefix',
          minSimilarity: 1,
          help: false,
          useWs: true,
          usePlugins: [
            PluginDef(AdapterOnebot, onebotConfig),
            ...(s3Config ? [PluginDef(S3Assets, s3Config)] : []),
          ],
        };
      },
    }),
    JwtModule.registerAsync({
      inject: [ConfigService],
      useFactory: (configService: ConfigService) =>
        configService.get<JwtModuleOptions>('jwt'),
    }),
  ],
  providers: [
    MessageService,
    AuthService,
    BotService,
    {
      provide: CENTER_ACCOUNT_TOKEN,
      inject: [ConfigService],
      useFactory: (configService: ConfigService) =>
        configService.get<string>('centerAccount'),
    },
  ],
  controllers: [AuthController],
})
export class AppModule {}
