import {
  ConsoleLogger,
  Injectable,
  OnApplicationBootstrap,
} from '@nestjs/common';
import { InjectContext, UseEvent, WireContextService } from 'koishi-nestjs';
import { Context, Session } from 'koishi';
import S3Assets from '@koishijs/plugin-assets-s3';

@Injectable()
export class MessageService
  extends ConsoleLogger
  implements OnApplicationBootstrap {
  constructor(@InjectContext() private ctx: Context) {
    super('message');
  }

  onApplicationBootstrap(): any {
    if (this.assets) {
      this.log(`Assets transformation enabled.`);
    }
  }

  @UseEvent('message')
  async onMessage(session: Session) {
    let content = session.content;
    if (this.assets) {
      try {
        content = await this.assets.transform(content);
      } catch (e) {
        content = session.content;
        this.error(`Failed to transform assets in message: ${e.message}`);
      }
    }
    // targetId, for private messages only
    const fromId = session.userId;
    const targetId = session.targetId || session.selfId;
    this.log(
      `Received message from ${session.username}(${fromId}) to ${targetId}: ${content}`,
    );
  }

  @WireContextService()
  private assets: S3Assets;
}
