import { Module } from '@nestjs/common';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { loadConfig } from './utility/config';
import { KoishiModule, PluginDef } from 'koishi-nestjs';
import AdapterOnebot, { BotConfig } from './onebot-improved';
import { Adapter } from 'koishi';
import { AdapterConfig } from './onebot-improved/utils';
import { MessageService } from './message/message.service';
import S3Assets from '@koishijs/plugin-assets-s3';

@Module({
  imports: [
    ConfigModule.forRoot({
      ignoreEnvVars: true,
      load: [loadConfig],
      isGlobal: true,
    }),
    KoishiModule.registerAsync({
      inject: [ConfigService],
      useFactory: async (configService: ConfigService) => {
        const onebotConfig =
          configService.get<Adapter.PluginConfig<AdapterConfig, BotConfig>>(
            'onebot',
          );
        const s3Config = configService.get<S3Assets.Config>('s3');
        return {
          prefix: '__never_prefix',
          minSimilarity: 1,
          help: false,
          useWs: true,
          usePlugins: [
            PluginDef(AdapterOnebot, onebotConfig),
            ...(s3Config ? [PluginDef(S3Assets, s3Config)] : []),
          ],
        };
      },
    }),
  ],
  providers: [MessageService],
})
export class AppModule {}
